/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGLength {
  @JsOverlay public static final double SVG_LENGTHTYPE_CM = SVGLength__Constants.SVG_LENGTHTYPE_CM;

  @JsOverlay
  public static final double SVG_LENGTHTYPE_EMS = SVGLength__Constants.SVG_LENGTHTYPE_EMS;

  @JsOverlay
  public static final double SVG_LENGTHTYPE_EXS = SVGLength__Constants.SVG_LENGTHTYPE_EXS;

  @JsOverlay public static final double SVG_LENGTHTYPE_IN = SVGLength__Constants.SVG_LENGTHTYPE_IN;
  @JsOverlay public static final double SVG_LENGTHTYPE_MM = SVGLength__Constants.SVG_LENGTHTYPE_MM;

  @JsOverlay
  public static final double SVG_LENGTHTYPE_NUMBER = SVGLength__Constants.SVG_LENGTHTYPE_NUMBER;

  @JsOverlay public static final double SVG_LENGTHTYPE_PC = SVGLength__Constants.SVG_LENGTHTYPE_PC;

  @JsOverlay
  public static final double SVG_LENGTHTYPE_PERCENTAGE =
      SVGLength__Constants.SVG_LENGTHTYPE_PERCENTAGE;

  @JsOverlay public static final double SVG_LENGTHTYPE_PT = SVGLength__Constants.SVG_LENGTHTYPE_PT;
  @JsOverlay public static final double SVG_LENGTHTYPE_PX = SVGLength__Constants.SVG_LENGTHTYPE_PX;

  @JsOverlay
  public static final double SVG_LENGTHTYPE_UNKNOWN = SVGLength__Constants.SVG_LENGTHTYPE_UNKNOWN;

  public int unitType;
  public double value;
  public String valueAsString;
  public double valueInSpecifiedUnits;

  public native void convertToSpecifiedUnits(int unitType);

  public native void newValueSpecifiedUnits(int unitType, double valueInSpecifiedUnits);
}
