/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGTextElement extends SVGTextPositioningElement implements SVGTransformable {
  public SVGElement farthestViewportElement;
  public SVGElement nearestViewportElement;
  public SVGAnimatedTransformList transform;

  public native SVGRect getBBox();

  public native SVGMatrix getCTM();

  @JsProperty
  public native SVGElement getFarthestViewportElement();

  @JsProperty
  public native SVGElement getNearestViewportElement();

  public native SVGMatrix getScreenCTM();

  @JsProperty
  public native SVGAnimatedTransformList getTransform();

  public native SVGMatrix getTransformToElement();

  public native SVGMatrix getTransformToElement(SVGElement element);

  @JsProperty
  public native void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  public native void setNearestViewportElement(SVGElement nearestViewportElement);

  @JsProperty
  public native void setTransform(SVGAnimatedTransformList transform);
}
