/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGViewElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGFitToViewBox, SVGZoomAndPan {
  @JsOverlay
  public static final double SVG_ZOOMANDPAN_DISABLE =
      SVGViewElement__Constants.SVG_ZOOMANDPAN_DISABLE;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_MAGNIFY =
      SVGViewElement__Constants.SVG_ZOOMANDPAN_MAGNIFY;

  @JsOverlay
  public static final double SVG_ZOOMANDPAN_UNKNOWN =
      SVGViewElement__Constants.SVG_ZOOMANDPAN_UNKNOWN;

  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGAnimatedRect viewBox;
  public SVGStringList viewTarget;
  public double zoomAndPan;

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native int getZoomAndPan();

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setZoomAndPan(int zoomAndPan);
}
