/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGLengthList {
  public int numberOfItems;

  public native SVGLength appendItem(SVGLength item);

  public native Object clear();

  public native SVGLength getItem(int index);

  public native SVGLength initialize(SVGLength item);

  public native SVGLength insertItemBefore(SVGLength item, int index);

  public native SVGLength removeItem(int index);

  public native SVGLength replaceItem(SVGLength item, int index);
}
