/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGMarkerElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGFitToViewBox, SVGLangSpace, SVGStylable {
  @JsOverlay
  public static final double SVG_MARKERUNITS_STROKEWIDTH =
      SVGMarkerElement__Constants.SVG_MARKERUNITS_STROKEWIDTH;

  @JsOverlay
  public static final double SVG_MARKERUNITS_UNKNOWN =
      SVGMarkerElement__Constants.SVG_MARKERUNITS_UNKNOWN;

  @JsOverlay
  public static final double SVG_MARKERUNITS_USERSPACEONUSE =
      SVGMarkerElement__Constants.SVG_MARKERUNITS_USERSPACEONUSE;

  @JsOverlay
  public static final double SVG_MARKER_ORIENT_ANGLE =
      SVGMarkerElement__Constants.SVG_MARKER_ORIENT_ANGLE;

  @JsOverlay
  public static final double SVG_MARKER_ORIENT_AUTO =
      SVGMarkerElement__Constants.SVG_MARKER_ORIENT_AUTO;

  @JsOverlay
  public static final double SVG_MARKER_ORIENT_UNKNOWN =
      SVGMarkerElement__Constants.SVG_MARKER_ORIENT_UNKNOWN;

  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedLength markerHeight;
  public SVGAnimatedEnumeration markerUnits;
  public SVGAnimatedLength markerWidth;
  public SVGAnimatedAngle orientAngle;
  public SVGAnimatedEnumeration orientType;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGAnimatedLength refX;
  public SVGAnimatedLength refY;
  public SVGAnimatedRect viewBox;
  public String xmllang;
  public String xmlspace;

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  public native void setOrientToAngle();

  public native void setOrientToAngle(SVGAngle angle);

  public native Object setOrientToAuto();

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
