/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGMaskElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGLangSpace, SVGStylable, SVGTests {
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedLength height;
  public SVGAnimatedEnumeration maskContentUnits;
  public SVGAnimatedEnumeration maskUnits;
  public SVGStringList requiredExtensions;
  public SVGStringList requiredFeatures;
  public SVGStringList systemLanguage;
  public SVGAnimatedLength width;
  public SVGAnimatedLength x;
  public String xmllang;
  public String xmlspace;
  public SVGAnimatedLength y;

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native SVGStringList getRequiredExtensions();

  @JsProperty
  public native SVGStringList getRequiredFeatures();

  @JsProperty
  public native SVGStringList getSystemLanguage();

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  public native boolean hasExtension();

  public native boolean hasExtension(String extension);

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setRequiredExtensions(SVGStringList requiredExtensions);

  @JsProperty
  public native void setRequiredFeatures(SVGStringList requiredFeatures);

  @JsProperty
  public native void setSystemLanguage(SVGStringList systemLanguage);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
