/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGRenderingIntent {
  @JsOverlay
  public static final double RENDERING_INTENT_ABSOLUTE_COLORIMETRIC =
      SVGRenderingIntent__Constants.RENDERING_INTENT_ABSOLUTE_COLORIMETRIC;

  @JsOverlay
  public static final double RENDERING_INTENT_AUTO =
      SVGRenderingIntent__Constants.RENDERING_INTENT_AUTO;

  @JsOverlay
  public static final double RENDERING_INTENT_PERCEPTUAL =
      SVGRenderingIntent__Constants.RENDERING_INTENT_PERCEPTUAL;

  @JsOverlay
  public static final double RENDERING_INTENT_RELATIVE_COLORIMETRIC =
      SVGRenderingIntent__Constants.RENDERING_INTENT_RELATIVE_COLORIMETRIC;

  @JsOverlay
  public static final double RENDERING_INTENT_SATURATION =
      SVGRenderingIntent__Constants.RENDERING_INTENT_SATURATION;

  @JsOverlay
  public static final double RENDERING_INTENT_UNKNOWN =
      SVGRenderingIntent__Constants.RENDERING_INTENT_UNKNOWN;
}
