/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.webgl;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface EXT_color_buffer_half_float {
  @JsProperty(name = "FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT")
  double getFRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT();

  @JsProperty(name = "RGB16F_EXT")
  double getRGB16F_EXT();

  @JsProperty(name = "RGBA16F_EXT")
  double getRGBA16F_EXT();

  @JsProperty(name = "UNSIGNED_NORMALIZED_EXT")
  double getUNSIGNED_NORMALIZED_EXT();
}
