/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.guice;

import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.guice.GuiceEndpointsServlet;
import com.google.api.server.spi.guice.ServiceMap;
import com.google.inject.servlet.ServletModule;
import java.util.Map;
import java.util.logging.Logger;

public class EndpointsModule
extends ServletModule {
    private static final Logger logger = Logger.getLogger(EndpointsModule.class.getName());

    protected void configureEndpoints(String urlPattern, Iterable<? extends Class<?>> serviceClasses) {
        this.configureEndpoints(urlPattern, serviceClasses, false);
    }

    @Deprecated
    protected void configureEndpoints(String urlPattern, Iterable<? extends Class<?>> serviceClasses, boolean useLegacyServlet) {
        ServletInitializationParameters initParameters = ServletInitializationParameters.builder().addServiceClasses(serviceClasses).build();
        this.configureEndpoints(urlPattern, initParameters, useLegacyServlet);
    }

    protected void configureEndpoints(String urlPattern, ServletInitializationParameters initParameters) {
        this.configureEndpoints(urlPattern, initParameters, false);
    }

    protected void configureEndpoints(String urlPattern, ServletInitializationParameters initParameters, boolean useLegacyServlet) {
        this.bind(ServiceMap.class).toInstance((Object)ServiceMap.create(this.binder(), initParameters.getServiceClasses()));
        if (useLegacyServlet) {
            logger.severe("the legacy servlet is no longer available.");
        }
        super.serve(urlPattern, new String[0]).with(GuiceEndpointsServlet.class, (Map)initParameters.asMap());
    }
}

