/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ApiAuthConfig {
    private boolean allowCookieAuth;
    private List<String> blockedRegions;

    public ApiAuthConfig() {
        this.setDefaults();
    }

    public ApiAuthConfig(ApiAuthConfig original) {
        this.allowCookieAuth = original.allowCookieAuth;
        this.blockedRegions = new ArrayList<String>(original.blockedRegions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiAuthConfig) {
            ApiAuthConfig config = (ApiAuthConfig)o;
            return Iterables.isEmpty(this.getConfigurationInconsistencies(config));
        }
        return false;
    }

    public Iterable<ApiConfigInconsistency<Object>> getConfigurationInconsistencies(ApiAuthConfig config) {
        return ApiConfigInconsistency.listBuilder().addIfInconsistent("auth.allowCookieAuth", this.allowCookieAuth, config.allowCookieAuth).addIfInconsistent("auth.blockedRegions", this.blockedRegions, config.blockedRegions).build();
    }

    public int hashCode() {
        return Objects.hash(this.allowCookieAuth, this.blockedRegions);
    }

    protected void setDefaults() {
        this.allowCookieAuth = false;
        this.blockedRegions = Collections.emptyList();
    }

    public void setAllowCookieAuth(boolean allowCookieAuth) {
        this.allowCookieAuth = allowCookieAuth;
    }

    public boolean getAllowCookieAuth() {
        return this.allowCookieAuth;
    }

    public void setBlockedRegions(List<String> blockedRegions) {
        this.blockedRegions = blockedRegions;
    }

    public List<String> getBlockedRegions() {
        return this.blockedRegions;
    }
}

