/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.dispatcher;

import com.google.api.server.spi.dispatcher.DispatcherContext;
import com.google.api.server.spi.dispatcher.DispatcherHandler;
import com.google.api.server.spi.dispatcher.PathTrie;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

public class PathDispatcher<ContextT extends DispatcherContext> {
    private final PathTrie<DispatcherNode<ContextT>> trie;

    private PathDispatcher(Builder<ContextT> builder) {
        this.trie = ((Builder)builder).trieBuilder.build();
    }

    public boolean dispatch(String httpMethod, String path, ContextT context) throws IOException {
        Preconditions.checkNotNull((Object)httpMethod, (Object)"httpMethod");
        Preconditions.checkNotNull((Object)path, (Object)"path");
        PathTrie.Result<DispatcherNode<ContextT>> result = this.trie.resolve(path);
        if (result != null) {
            DispatcherNode<ContextT> node = result.getResult();
            DispatcherHandler<ContextT> handler = node.get(httpMethod);
            if (handler != null) {
                ((DispatcherContext)context).setRawPathParameters(result.getRawParameters());
                handler.handle(context);
            }
            return true;
        }
        return false;
    }

    public static <T extends DispatcherContext> Builder<T> builder() {
        return new Builder();
    }

    private static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }

    private static class DispatcherNode<ContextT extends DispatcherContext> {
        private final Map<HttpMethod, DispatcherHandler<ContextT>> handlerMap = new EnumMap<HttpMethod, DispatcherHandler<ContextT>>(HttpMethod.class);

        private DispatcherNode() {
        }

        DispatcherHandler<ContextT> get(String httpMethod) {
            return this.handlerMap.get((Object)HttpMethod.valueOf(httpMethod));
        }
    }

    public static class Builder<T extends DispatcherContext> {
        private final PathTrie.Builder<DispatcherNode<T>> trieBuilder = PathTrie.builder();

        public Builder<T> add(String httpMethod, String pathTemplate, DispatcherHandler<T> handler) {
            Preconditions.checkNotNull((Object)httpMethod, (Object)"httpMethod");
            Preconditions.checkNotNull((Object)pathTemplate, (Object)"pathTemplate");
            Preconditions.checkNotNull(handler, (Object)"handler");
            ((DispatcherNode)this.getOrCreateNode(pathTemplate)).handlerMap.put(HttpMethod.valueOf(httpMethod.toUpperCase()), handler);
            return this;
        }

        public PathDispatcher<T> build() {
            return new PathDispatcher(this);
        }

        private DispatcherNode<T> getOrCreateNode(String pathTemplate) {
            DispatcherNode<Object> node = this.trieBuilder.get(pathTemplate);
            if (node == null) {
                node = new DispatcherNode();
                this.trieBuilder.add(pathTemplate, node);
            }
            return node;
        }
    }
}

