/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import java.util.HashMap;
import java.util.Map;

public class ErrorMap {
    private static Map<Integer, Error> errors = ErrorMap.createErrorMap();
    private final boolean enableExceptionCompatibility;

    public ErrorMap() {
        this(true);
    }

    public ErrorMap(boolean enableExceptionCompatibility) {
        this.enableExceptionCompatibility = enableExceptionCompatibility;
    }

    public int getHttpStatus(int lilyStatus) {
        if (!this.enableExceptionCompatibility) {
            return lilyStatus;
        }
        if (lilyStatus >= 500) {
            return 503;
        }
        Error error = errors.get(lilyStatus);
        if (error == null) {
            return 404;
        }
        return error.httpStatus;
    }

    public int getRpcStatus(int lilyStatus) {
        if (lilyStatus >= 500) {
            return -32099;
        }
        Error error = errors.get(lilyStatus);
        if (error == null) {
            return 404;
        }
        return error.rpcStatus;
    }

    public String getReason(int lilyStatus) {
        if (lilyStatus >= 500) {
            return "backendError";
        }
        Error error = errors.get(lilyStatus);
        if (error == null) {
            return "unsupportedProtocol";
        }
        return this.enableExceptionCompatibility ? error.compatibilityReason : error.reason;
    }

    public String getDomain(int lilyStatus) {
        if (lilyStatus >= 500) {
            return "global";
        }
        Error error = errors.get(lilyStatus);
        if (error == null) {
            return "global";
        }
        return error.domain;
    }

    private static Map<Integer, Error> createErrorMap() {
        HashMap<Integer, Error> errors = new HashMap<Integer, Error>();
        errors.put(400, new Error(400, 400, "badRequest", "global"));
        errors.put(401, new Error(401, 401, "required", "global"));
        errors.put(402, new Error(404, 404, "unsupportedProtocol", "paymentRequired", "global"));
        errors.put(403, new Error(403, 403, "forbidden", "global"));
        errors.put(404, new Error(404, 404, "notFound", "global"));
        errors.put(405, new Error(501, 501, "unsupportedMethod", "global"));
        errors.put(406, new Error(404, 404, "unsupportedProtocol", "notAcceptable", "global"));
        errors.put(407, new Error(404, 404, "unsupportedProtocol", "proxyAuthentication", "global"));
        errors.put(408, new Error(503, -32099, "backendError", "requestTimeout", "global"));
        errors.put(409, new Error(409, 409, "conflict", "global"));
        errors.put(410, new Error(410, 410, "deleted", "global"));
        errors.put(411, new Error(404, 404, "unsupportedProtocol", "lengthRequired", "global"));
        errors.put(412, new Error(412, 412, "conditionNotMet", "global"));
        errors.put(413, new Error(413, 413, "uploadTooLarge", "global"));
        errors.put(414, new Error(404, 404, "unsupportedProtocol", "uriTooLong", "global"));
        errors.put(415, new Error(404, 404, "unsupportedProtocol", "unsupportedMediaType", "global"));
        errors.put(416, new Error(404, 404, "unsupportedProtocol", "rangeNotSatisfiable", "global"));
        errors.put(417, new Error(404, 404, "unsupportedProtocol", "expectationFailed", "global"));
        return errors;
    }

    private static class Error {
        private final int httpStatus;
        private final int rpcStatus;
        private final String compatibilityReason;
        private final String reason;
        private final String domain;

        Error(int httpStatus, int rpcStatus, String reason, String domain) {
            this(httpStatus, rpcStatus, reason, reason, domain);
        }

        Error(int httpStatus, int rpcStatus, String compatibilityReason, String reason, String domain) {
            this.httpStatus = httpStatus;
            this.rpcStatus = rpcStatus;
            this.compatibilityReason = compatibilityReason;
            this.reason = reason;
            this.domain = domain;
        }
    }
}

