/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.model.ApiAuthConfig;
import com.google.api.server.spi.config.model.ApiCacheControlConfig;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiFrontendLimitsConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiIssuerConfigs;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiNamespaceConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ApiConfig {
    private static final AuthScopeExpression DEFAULT_SCOPE_EXPRESSION = AuthScopeExpressions.interpret("https://www.googleapis.com/auth/userinfo.email");
    private static final List<String> DEFAULT_CLIENT_IDS = ImmutableList.of((Object)"292824132082.apps.googleusercontent.com");
    private final TypeLoader typeLoader;
    private String root;
    private String name;
    private String canonicalName;
    private String version;
    private String title;
    private String description;
    private String documentationLink;
    private String backendRoot;
    private boolean isAbstract;
    private boolean defaultVersion;
    private boolean discoverable;
    private String resource;
    private boolean useDatastore;
    private AuthLevel authLevel;
    private AuthScopeExpression scopeExpression;
    private List<String> audiences;
    private ApiIssuerConfigs issuers;
    private ApiIssuerAudienceConfig issuerAudiences;
    private List<String> clientIds;
    private List<Class<? extends Authenticator>> authenticators;
    private List<Class<? extends PeerAuthenticator>> peerAuthenticators;
    private boolean apiKeyRequired;
    private final ApiAuthConfig authConfig;
    private final ApiCacheControlConfig cacheControlConfig;
    private final ApiFrontendLimitsConfig frontendLimitsConfig;
    private final ApiSerializationConfig serializationConfig;
    private final ApiNamespaceConfig namespaceConfig;
    private final ApiClassConfig apiClassConfig;

    protected ApiConfig(ServiceContext serviceContext, TypeLoader typeLoader, Class<?> apiClass) {
        this.typeLoader = typeLoader;
        this.authConfig = this.createAuthConfig();
        this.cacheControlConfig = this.createCacheControlConfig();
        this.frontendLimitsConfig = this.createFrontendLimitsConfig();
        this.serializationConfig = this.createSerializationConfig();
        this.namespaceConfig = this.createNamespaceConfig();
        this.apiClassConfig = this.createApiClassConfig(typeLoader, apiClass);
        this.setDefaults(serviceContext);
    }

    protected ApiConfig(ApiConfig original) {
        this.typeLoader = original.typeLoader;
        this.root = original.root;
        this.name = original.name;
        this.canonicalName = original.canonicalName;
        this.version = original.version;
        this.title = original.title;
        this.description = original.description;
        this.documentationLink = original.documentationLink;
        this.backendRoot = original.backendRoot;
        this.isAbstract = original.isAbstract;
        this.defaultVersion = original.defaultVersion;
        this.discoverable = original.discoverable;
        this.resource = original.resource;
        this.useDatastore = original.useDatastore;
        this.authLevel = original.authLevel;
        this.scopeExpression = original.scopeExpression;
        this.audiences = original.audiences == null ? null : new ArrayList<String>(original.audiences);
        this.issuers = original.issuers;
        this.issuerAudiences = original.issuerAudiences;
        this.clientIds = original.clientIds == null ? null : new ArrayList<String>(original.clientIds);
        this.authenticators = original.authenticators;
        this.peerAuthenticators = original.peerAuthenticators;
        this.apiKeyRequired = original.apiKeyRequired;
        this.authConfig = new ApiAuthConfig(original.authConfig);
        this.cacheControlConfig = new ApiCacheControlConfig(original.cacheControlConfig);
        this.frontendLimitsConfig = new ApiFrontendLimitsConfig(original.frontendLimitsConfig);
        this.serializationConfig = new ApiSerializationConfig(original.serializationConfig);
        this.namespaceConfig = new ApiNamespaceConfig(original.namespaceConfig);
        this.apiClassConfig = new ApiClassConfig(original.apiClassConfig, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiConfig) {
            ApiConfig config = (ApiConfig)o;
            return Iterables.isEmpty(this.getConfigurationInconsistencies(config)) && this.apiClassConfig.equals(config.apiClassConfig);
        }
        return false;
    }

    public Iterable<ApiConfigInconsistency<Object>> getConfigurationInconsistencies(ApiConfig config) {
        return ApiConfigInconsistency.listBuilder().addIfInconsistent("typeLoader", this.typeLoader, config.typeLoader).addIfInconsistent("root", this.root, config.root).addIfInconsistent("name", this.name, config.name).addIfInconsistent("cannonicalName", this.canonicalName, config.canonicalName).addIfInconsistent("version", this.version, config.version).addIfInconsistent("title", this.title, config.title).addIfInconsistent("description", this.description, config.description).addIfInconsistent("documentationLink", this.documentationLink, config.documentationLink).addIfInconsistent("backendRoot", this.backendRoot, config.backendRoot).addIfInconsistent("isAbstract", this.isAbstract, config.isAbstract).addIfInconsistent("defaultVersion", this.defaultVersion, config.defaultVersion).addIfInconsistent("discoverable", this.discoverable, config.discoverable).addIfInconsistent("useDatastore", this.useDatastore, config.useDatastore).addIfInconsistent("resource", this.resource, config.resource).addIfInconsistent("authLevel", this.authLevel, config.authLevel).addIfInconsistent("scopeExpression", this.scopeExpression, config.scopeExpression).addIfInconsistent("audiences", this.audiences, config.audiences).addIfInconsistent("issuers", this.issuers, config.issuers).addIfInconsistent("issuerAudiencies", this.issuerAudiences, config.issuerAudiences).addIfInconsistent("clientIds", this.clientIds, config.clientIds).addIfInconsistent("authenticators", this.authenticators, config.authenticators).addIfInconsistent("peerAuthenticators", this.peerAuthenticators, config.peerAuthenticators).addIfInconsistent("apiKeyRequired", this.apiKeyRequired, config.apiKeyRequired).addAll(this.authConfig.getConfigurationInconsistencies(config.authConfig)).addAll(this.cacheControlConfig.getConfigurationInconsistencies(config.cacheControlConfig)).addAll(this.frontendLimitsConfig.getConfigurationInconsistencies(config.frontendLimitsConfig)).addAll(this.serializationConfig.getConfigurationInconsistencies(config.serializationConfig)).addAll(this.namespaceConfig.getConfigurationInconsistencies(config.namespaceConfig)).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeLoader, this.root, this.name, this.canonicalName, this.version, this.title, this.description, this.documentationLink, this.backendRoot, this.isAbstract, this.defaultVersion, this.discoverable, this.useDatastore, this.resource, this.authLevel, this.scopeExpression, this.audiences, this.clientIds, this.authenticators, this.peerAuthenticators, this.authConfig, this.cacheControlConfig, this.frontendLimitsConfig, this.serializationConfig, this.apiClassConfig, this.issuers, this.issuerAudiences, this.apiKeyRequired});
    }

    protected ApiAuthConfig createAuthConfig() {
        return new ApiAuthConfig();
    }

    protected ApiCacheControlConfig createCacheControlConfig() {
        return new ApiCacheControlConfig();
    }

    protected ApiFrontendLimitsConfig createFrontendLimitsConfig() {
        return new ApiFrontendLimitsConfig();
    }

    protected ApiSerializationConfig createSerializationConfig() {
        return new ApiSerializationConfig();
    }

    protected ApiNamespaceConfig createNamespaceConfig() {
        return new ApiNamespaceConfig();
    }

    protected ApiClassConfig createApiClassConfig(TypeLoader typeLoader, Class<?> apiClass) {
        return new ApiClassConfig(this, typeLoader, apiClass);
    }

    protected void setDefaults(ServiceContext serviceContext) {
        this.root = serviceContext.getTransferProtocol() + "://" + serviceContext.getAppHostName() + "/_ah/api";
        this.name = serviceContext.getDefaultApiName();
        this.canonicalName = null;
        this.version = "v1";
        this.description = null;
        this.backendRoot = serviceContext.getTransferProtocol() + "://" + serviceContext.getAppHostName() + "/_ah/spi";
        this.isAbstract = false;
        this.defaultVersion = false;
        this.discoverable = true;
        this.useDatastore = false;
        this.resource = null;
        this.authLevel = AuthLevel.NONE;
        this.scopeExpression = DEFAULT_SCOPE_EXPRESSION;
        this.audiences = Collections.emptyList();
        this.issuers = ApiIssuerConfigs.EMPTY;
        this.issuerAudiences = ApiIssuerAudienceConfig.EMPTY;
        this.clientIds = DEFAULT_CLIENT_IDS;
        this.authenticators = null;
        this.peerAuthenticators = null;
        this.apiKeyRequired = false;
    }

    public ApiKey getApiKey() {
        return new ApiKey(this.name, this.version, this.root);
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDocumentationLink(String documentationLink) {
        this.documentationLink = documentationLink;
    }

    public String getDocumentationLink() {
        return this.documentationLink;
    }

    public void setBackendRoot(String backendRoot) {
        this.backendRoot = this.toHttps(backendRoot);
    }

    public String getBackendRoot() {
        return this.backendRoot;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean getIsAbstract() {
        return this.isAbstract;
    }

    public void setIsDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public boolean getIsDefaultVersion() {
        return this.defaultVersion;
    }

    public void setIsDiscoverable(boolean discoverable) {
        this.discoverable = discoverable;
    }

    public boolean getIsDiscoverable() {
        return this.discoverable;
    }

    public void setUseDatastore(boolean useDatastore) {
        this.useDatastore = useDatastore;
    }

    public boolean getUseDatastore() {
        return this.useDatastore;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public ApiAuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public ApiCacheControlConfig getCacheControlConfig() {
        return this.cacheControlConfig;
    }

    public ApiFrontendLimitsConfig getFrontendLimitsConfig() {
        return this.frontendLimitsConfig;
    }

    public ApiSerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ApiNamespaceConfig getNamespaceConfig() {
        return this.namespaceConfig;
    }

    public void setAuthLevel(AuthLevel authLevel) {
        this.authLevel = authLevel;
    }

    public AuthLevel getAuthLevel() {
        return this.authLevel;
    }

    public void setScopeExpression(AuthScopeExpression scopeExpression) {
        this.scopeExpression = scopeExpression;
    }

    public AuthScopeExpression getScopeExpression() {
        return this.scopeExpression;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setIssuers(ApiIssuerConfigs issuers) {
        this.issuers = issuers;
    }

    public void ensureGoogleIssuer() {
        this.issuers = this.issuers.withGoogleIdToken();
    }

    public ApiIssuerConfigs getIssuers() {
        return this.issuers;
    }

    public void setIssuerAudiences(ApiIssuerAudienceConfig issuerAudiences) {
        Preconditions.checkNotNull((Object)issuerAudiences, (Object)"issuerAudiences should never be null");
        this.issuerAudiences = issuerAudiences;
        if (issuerAudiences.hasIssuer("google_id_token")) {
            this.ensureGoogleIssuer();
        }
    }

    public ApiIssuerAudienceConfig getIssuerAudiences() {
        return this.issuerAudiences;
    }

    public void setClientIds(List<String> clientIds) {
        this.clientIds = clientIds;
    }

    public List<String> getClientIds() {
        return this.clientIds;
    }

    public void setAuthenticators(List<Class<? extends Authenticator>> authenticators) {
        this.authenticators = authenticators;
    }

    public List<Class<? extends Authenticator>> getAuthenticators() {
        return this.authenticators;
    }

    public void setPeerAuthenticators(List<Class<? extends PeerAuthenticator>> peerAuthenticators) {
        this.peerAuthenticators = peerAuthenticators;
    }

    public List<Class<? extends PeerAuthenticator>> getPeerAuthenticators() {
        return this.peerAuthenticators;
    }

    public void setApiKeyRequired(boolean apiKeyRequired) {
        this.apiKeyRequired = apiKeyRequired;
    }

    public boolean isApiKeyRequired() {
        return this.apiKeyRequired;
    }

    private String toHttps(String url) {
        if (url != null && url.startsWith("http:")) {
            return "https:" + url.substring(5);
        }
        return url;
    }

    public ApiClassConfig getApiClassConfig() {
        return this.apiClassConfig;
    }

    public static class Factory {
        public ApiConfig create(ServiceContext serviceContext, TypeLoader typeLoader, Class<?> endpointClass) {
            return new ApiConfig(serviceContext, typeLoader, endpointClass);
        }

        public ApiConfig copy(ApiConfig old) {
            return new ApiConfig(old);
        }
    }
}

