/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.EndpointsContext;
import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.Strings;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.dispatcher.PathDispatcher;
import com.google.api.server.spi.handlers.ApiProxyHandler;
import com.google.api.server.spi.handlers.CorsHandler;
import com.google.api.server.spi.handlers.EndpointsMethodHandler;
import com.google.api.server.spi.handlers.ExplorerHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EndpointsServlet
extends HttpServlet {
    private static final String EXPLORER_PATH = "explorer";
    private ServletInitializationParameters initParameters;
    private SystemService systemService;
    private PathDispatcher<EndpointsContext> dispatcher;
    private CorsHandler corsHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.initParameters = ServletInitializationParameters.fromServletConfig(config, classLoader);
        this.systemService = this.createSystemService(classLoader, this.initParameters);
        this.dispatcher = this.createDispatcher();
        this.corsHandler = new CorsHandler();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.corsHandler.handle(request, response);
        } else {
            String path = Strings.stripSlash(request.getRequestURI().substring(request.getServletPath().length()));
            EndpointsContext context = new EndpointsContext(request.getMethod(), path, request, response);
            if (!this.dispatcher.dispatch(request.getMethod(), path, context)) {
                response.setStatus(404);
                response.getWriter().append("Not Found");
            }
        }
    }

    private PathDispatcher<EndpointsContext> createDispatcher() {
        PathDispatcher.Builder<EndpointsContext> builder = PathDispatcher.builder();
        ImmutableList<SystemService.EndpointNode> endpoints = this.systemService.getEndpoints();
        ImmutableList.Builder handlersBuilder = ImmutableList.builder();
        for (SystemService.EndpointNode endpoint : endpoints) {
            ApiConfig apiConfig = endpoint.getConfig();
            ApiClassConfig.MethodConfigMap methods = apiConfig.getApiClassConfig().getMethods();
            for (Map.Entry methodEntry : methods.entrySet()) {
                if (((ApiMethodConfig)methodEntry.getValue()).isIgnored()) continue;
                handlersBuilder.add((Object)new EndpointsMethodHandler(this.initParameters, this.getServletContext(), (EndpointMethod)methodEntry.getKey(), apiConfig, (ApiMethodConfig)methodEntry.getValue(), this.systemService));
            }
        }
        ImmutableList handlers = handlersBuilder.build();
        for (EndpointsMethodHandler handler : handlers) {
            builder.add(handler.getRestMethod(), Strings.stripTrailingSlash(handler.getRestPath()), handler.getRestHandler());
        }
        ExplorerHandler explorerHandler = new ExplorerHandler();
        builder.add("GET", EXPLORER_PATH, explorerHandler);
        builder.add("GET", "explorer/", explorerHandler);
        builder.add("GET", "static/proxy.html", new ApiProxyHandler());
        return builder.build();
    }

    private SystemService createSystemService(ClassLoader classLoader, ServletInitializationParameters initParameters) throws ServletException {
        try {
            SystemService.Builder builder = SystemService.builder().withDefaults(classLoader).setStandardConfigLoader(classLoader, false).setIllegalArgumentIsBackendError(initParameters.isIllegalArgumentBackendError()).setBackendServiceEnabled(false).setDiscoveryServiceEnabled(true);
            for (Class serviceClass : initParameters.getServiceClasses()) {
                builder.addService(serviceClass, this.createService(serviceClass));
            }
            return builder.build();
        }
        catch (ApiConfigException | ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected <T> T createService(Class<T> serviceClass) {
        try {
            return serviceClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format("Cannot instantiate service class: %s", serviceClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Cannot access service class: %s", serviceClass.getName()), e);
        }
    }
}

