/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.Service;
import com.google.api.auth.Authenticator;
import com.google.api.auth.UnauthenticatedException;
import com.google.api.auth.UserInfo;
import com.google.api.control.ConfigFilter;
import com.google.api.control.model.MethodRegistry;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Singleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

@Singleton
public final class EspAuthenticator
implements com.google.api.server.spi.config.Authenticator {
    private static final Logger logger = Logger.getLogger(EspAuthenticator.class.getName());
    private final Authenticator authenticator;

    public EspAuthenticator() {
        this(Authenticator.create());
    }

    @VisibleForTesting
    EspAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public User authenticate(HttpServletRequest request) {
        MethodRegistry.Info methodInfo = ConfigFilter.getMethodInfo((ServletRequest)request);
        if (methodInfo == null) {
            throw new IllegalStateException("method_info is not set in the request");
        }
        Optional authInfo = methodInfo.getAuthInfo();
        if (!authInfo.isPresent()) {
            logger.info("auth is not configured for this request");
            return null;
        }
        Service service = ConfigFilter.getService((ServletRequest)request);
        if (service == null) {
            throw new IllegalStateException("service is not set in the request");
        }
        String serviceName = service.getName();
        try {
            UserInfo userInfo = this.authenticator.authenticate(request, (MethodRegistry.AuthInfo)authInfo.get(), serviceName);
            return new User(userInfo.getId(), userInfo.getEmail());
        }
        catch (UnauthenticatedException | UncheckedExecutionException exception) {
            logger.warning(String.format("Authentication failed: %s", exception));
            return null;
        }
    }
}

