/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ApiTransformer;
import com.google.api.server.spi.config.Transformer;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class Serializers {
    private Serializers() {
    }

    public static <S extends Transformer<?, ?>> S instantiate(Class<S> serializerClass, Type sourceType) {
        if (!TypeToken.of((Type)Serializers.getSourceType(serializerClass)).isSupertypeOf(sourceType)) {
            throw new IllegalArgumentException(String.format("Can not instantiate %s, the serializer source %s is not assignable from %s", serializerClass, Serializers.getSourceType(serializerClass), sourceType));
        }
        Throwable parentException = null;
        for (SerializerConstructor constructor : SerializerConstructor.values()) {
            try {
                return constructor.construct(serializerClass, sourceType);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to instantiate custom serializer constructor %s%s with source type: %s", new Object[]{serializerClass.getName(), constructor, sourceType});
                throw new IllegalStateException(errorMessage, e);
            }
        }
        String message = String.format("Failed to instantiate custom serializer %s, constructors not found: %s", serializerClass.getName(), Arrays.toString((Object[])SerializerConstructor.values()));
        throw new IllegalStateException(message, parentException);
    }

    public static List<Class<? extends Transformer<?, ?>>> getSerializerClasses(@Nullable Type type, @Nullable ApiSerializationConfig config) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList allParentSerializers = Lists.newArrayList();
        ArrayList serializedTypes = Lists.newArrayList();
        for (TypeToken typeToken : TypeToken.of((Type)type).getTypes()) {
            ApiSerializationConfig.SerializerConfig serializerConfig;
            ApiTransformer apiSerialization = typeToken.getRawType().getAnnotation(ApiTransformer.class);
            if (Serializers.isSupertypeOf(typeToken, serializedTypes)) continue;
            if (apiSerialization != null) {
                allParentSerializers.add(apiSerialization.value());
                serializedTypes.add(typeToken);
                continue;
            }
            if (config == null || (serializerConfig = config.getSerializerConfig(typeToken.getType())) == null) continue;
            allParentSerializers.add(serializerConfig.getSerializer());
            serializedTypes.add(typeToken);
        }
        return allParentSerializers;
    }

    @Nullable
    public static Type getSourceType(@Nullable Class<? extends Transformer<?, ?>> clazz) {
        ParameterizedType types = Serializers.getResolvedType(clazz);
        return types == null ? null : types.getActualTypeArguments()[0];
    }

    @Nullable
    public static Type getTargetType(@Nullable Class<? extends Transformer<?, ?>> clazz) {
        ParameterizedType types = Serializers.getResolvedType(clazz);
        return types == null ? null : types.getActualTypeArguments()[1];
    }

    @Nullable
    private static ParameterizedType getResolvedType(@Nullable Class<? extends Transformer<?, ?>> clazz) {
        if (clazz == null || !Transformer.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (TypeToken token : TypeToken.of(clazz).getTypes().interfaces()) {
            if (!token.getRawType().equals(Transformer.class)) continue;
            Type tokenType = token.getType();
            return tokenType instanceof ParameterizedType ? (ParameterizedType)tokenType : null;
        }
        return null;
    }

    private static boolean isSupertypeOf(TypeToken<?> typeToken, List<TypeToken<?>> subtypes) {
        for (TypeToken<?> subType : subtypes) {
            if (!typeToken.isSupertypeOf(subType)) continue;
            return true;
        }
        return false;
    }

    private static enum SerializerConstructor {
        TYPE{

            @Override
            <S extends Transformer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                return (S)((Transformer)serializerClass.getDeclaredConstructor(Type.class).newInstance(sourceType));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of(Type.class);
            }
        }
        ,
        CLASS{

            @Override
            <S extends Transformer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                Class sourceClass = TypeToken.of((Type)sourceType).getRawType();
                return (S)((Transformer)serializerClass.getDeclaredConstructor(Class.class).newInstance(sourceClass));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of(Class.class);
            }
        }
        ,
        DEFAULT{

            @Override
            <S extends Transformer<?, ?>> S construct(Class<S> serializerClass, Type sourceType) throws Exception {
                return (S)((Transformer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }

            @Override
            ImmutableList<Type> getArgs() {
                return ImmutableList.of();
            }
        };


        abstract <S extends Transformer<?, ?>> S construct(Class<S> var1, Type var2) throws Exception;

        abstract ImmutableList<Type> getArgs();

        public String toString() {
            return String.format("(%s)", Joiner.on((String)", ").join(this.getArgs()));
        }
    }
}

