/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.Client;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.ApiKey;
import com.google.api.server.spi.discovery.DiscoveryProvider;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.services.discovery.Discovery;
import com.google.api.services.discovery.model.ApiConfig;
import com.google.api.services.discovery.model.ApiConfigs;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyingDiscoveryProvider
implements DiscoveryProvider {
    private static final Logger logger = Logger.getLogger(ProxyingDiscoveryProvider.class.getName());
    private static final Function<com.google.api.server.spi.config.ApiConfig, ApiKey> CONFIG_TO_ROOTLESS_KEY = new Function<com.google.api.server.spi.config.ApiConfig, ApiKey>(){

        public ApiKey apply(com.google.api.server.spi.config.ApiConfig config) {
            return new ApiKey(config.getName(), config.getVersion(), null);
        }
    };
    private final ImmutableList<com.google.api.server.spi.config.ApiConfig> apiConfigs;
    private final ImmutableListMultimap<ApiKey, com.google.api.server.spi.config.ApiConfig> configsByKey;
    private final ApiConfigWriter configWriter;
    private final Discovery discovery;

    public ProxyingDiscoveryProvider(ImmutableList<com.google.api.server.spi.config.ApiConfig> apiConfigs, ApiConfigWriter configWriter) {
        this(apiConfigs, configWriter, ProxyingDiscoveryProvider.createDiscovery());
    }

    public ProxyingDiscoveryProvider(ImmutableList<com.google.api.server.spi.config.ApiConfig> apiConfigs, ApiConfigWriter configWriter, Discovery discovery) {
        this.apiConfigs = apiConfigs;
        this.configsByKey = FluentIterable.from(apiConfigs).index(CONFIG_TO_ROOTLESS_KEY);
        this.configWriter = configWriter;
        this.discovery = discovery;
    }

    @Override
    public RestDescription getRestDocument(String root, String name, String version) throws NotFoundException, InternalServerErrorException {
        try {
            ApiKey key = new ApiKey(name, version, null);
            ImmutableList configs = this.configsByKey.get((Object)key);
            if (configs.isEmpty()) {
                logger.info("No configuration found for name: " + name + ", version: " + version);
                throw new NotFoundException("Not Found");
            }
            return (RestDescription)((Object)this.discovery.apis().generateRest(new ApiConfig().setConfig(this.getApiConfigStringWithRoot((ImmutableList<com.google.api.server.spi.config.ApiConfig>)configs, root))).execute());
        }
        catch (ApiConfigException | IOException e) {
            logger.log(Level.SEVERE, "Could not generate or cache discovery doc", e);
            throw new InternalServerErrorException("Internal Server Error", (Throwable)e);
        }
    }

    @Override
    public RpcDescription getRpcDocument(String root, String name, String version) throws NotFoundException, InternalServerErrorException {
        try {
            ApiKey key = new ApiKey(name, version, null);
            ImmutableList configs = this.configsByKey.get((Object)key);
            if (configs.isEmpty()) {
                logger.info("No configuration found for name: " + name + ", version: " + version);
                throw new NotFoundException("Not Found");
            }
            return (RpcDescription)((Object)this.discovery.apis().generateRpc(new ApiConfig().setConfig(this.getApiConfigStringWithRoot((ImmutableList<com.google.api.server.spi.config.ApiConfig>)configs, root))).execute());
        }
        catch (ApiConfigException | IOException e) {
            logger.log(Level.SEVERE, "Could not generate or cache discovery doc", e);
            throw new InternalServerErrorException("Internal Server Error", (Throwable)e);
        }
    }

    @Override
    public DirectoryList getDirectory(String root) throws InternalServerErrorException {
        try {
            Map<ApiKey, String> configStrings = this.configWriter.writeConfig(ProxyingDiscoveryProvider.rewriteConfigsWithRoot(this.apiConfigs, root));
            ApiConfigs configs = new ApiConfigs();
            configs.setConfigs(Lists.newArrayList(configStrings.values()));
            return (DirectoryList)((Object)this.discovery.apis().generateDirectory(configs).execute());
        }
        catch (ApiConfigException | IOException e) {
            logger.log(Level.SEVERE, "Could not generate or cache directory", e);
            throw new InternalServerErrorException("Internal Server Error", (Throwable)e);
        }
    }

    private String getApiConfigStringWithRoot(ImmutableList<com.google.api.server.spi.config.ApiConfig> configs, String root) throws InternalServerErrorException, ApiConfigException {
        Map<ApiKey, String> configMap = this.configWriter.writeConfig(ProxyingDiscoveryProvider.rewriteConfigsWithRoot(configs, root));
        if (configMap.size() != 1) {
            logger.severe("config generation yielded more than one API");
            throw new InternalServerErrorException("Internal Server Error");
        }
        return (String)Iterables.getFirst(configMap.values(), null);
    }

    private static Iterable<com.google.api.server.spi.config.ApiConfig> rewriteConfigsWithRoot(Iterable<com.google.api.server.spi.config.ApiConfig> configs, String root) {
        ApiConfig.Factory factory = new ApiConfig.Factory();
        return FluentIterable.from(configs).transform((Function)new RootRemapperFunction(root, factory));
    }

    private static Discovery createDiscovery() {
        Client client = Client.getInstance();
        return new Discovery.Builder(client.getHttpTransport(), client.getJsonFactory(), null).build();
    }

    private static class RootRemapperFunction
    implements Function<com.google.api.server.spi.config.ApiConfig, com.google.api.server.spi.config.ApiConfig> {
        private final String root;
        private final ApiConfig.Factory factory;

        RootRemapperFunction(String root, ApiConfig.Factory factory) {
            this.root = root;
            this.factory = factory;
        }

        public com.google.api.server.spi.config.ApiConfig apply(com.google.api.server.spi.config.ApiConfig input) {
            com.google.api.server.spi.config.ApiConfig copy = this.factory.copy(input);
            copy.setRoot(this.root);
            return copy;
        }
    }
}

