/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.PeerAuth;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.request.Attribute;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.request.ServletRequestParamReader;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.response.ServletResponseResultWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SystemServiceServlet
extends HttpServlet {
    private static final Pattern PATH_PATTERN = Pattern.compile("/([^/]+)\\.([^/]+)");
    private static final Logger logger = Logger.getLogger(SystemServiceServlet.class.getName());
    private volatile SystemService systemService;
    private volatile ServletInitializationParameters initParameters;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ClassLoader classLoader = this.getUserClassLoader(config);
        this.initParameters = ServletInitializationParameters.fromServletConfig(config, classLoader);
        logger.log(Level.INFO, "SPI restricted: {0}", this.initParameters.isServletRestricted());
        this.systemService = this.createSystemService(classLoader, this.initParameters);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo();
        String[] pathParams = this.getPathParams(path);
        if (pathParams != null) {
            try {
                String serviceName = pathParams[0];
                String methodName = pathParams[1];
                this.execute(request, response, serviceName, methodName);
            }
            catch (ServiceException e) {
                this.getErrorResponseWriter(response).writeError(e);
            }
        } else {
            this.getErrorResponseWriter(response).writeError(new BadRequestException("missing /{Service}.{method}"));
        }
    }

    private ParamReader getParamReader(EndpointMethod method, ApiSerializationConfig serializationConfig, HttpServletRequest request) {
        return new ServletRequestParamReader(method, request, this.getServletContext(), serializationConfig);
    }

    private ResultWriter getResponseWriter(ApiSerializationConfig serializationConfig, HttpServletResponse response) {
        return new ServletResponseResultWriter(response, serializationConfig);
    }

    private ResultWriter getErrorResponseWriter(HttpServletResponse response) {
        return this.getResponseWriter(null, response);
    }

    protected void execute(HttpServletRequest request, HttpServletResponse response, String serviceName, String methodName) throws IOException, ServiceException {
        logger.log(Level.FINE, "serviceName={0} methodName={1}", new Object[]{serviceName, methodName});
        EndpointMethod serviceMethod = this.systemService.resolveService(serviceName, methodName);
        ApiSerializationConfig serializationConfig = this.systemService.getSerializationConfig(serviceName);
        ResultWriter responseWriter = this.getResponseWriter(serializationConfig, response);
        logger.log(Level.FINE, "serviceMethod={0}", serviceMethod);
        ApiMethodConfig methodConfig = this.systemService.resolveAndUpdateServiceConfig(serviceName, methodName);
        Attribute.bindStandardRequestAttributes(request, methodConfig, this.initParameters);
        if (!PeerAuth.from(request).authorizePeer()) {
            logger.info("SPI restricted and request denied");
            this.getErrorResponseWriter(response).writeError(new NotFoundException("Not found"));
            return;
        }
        ParamReader requestReader = this.getParamReader(serviceMethod, serializationConfig, request);
        this.systemService.invokeServiceMethod(this.systemService.findService(serviceName), serviceMethod.getMethod(), requestReader, responseWriter);
    }

    private String[] getPathParams(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }

    private SystemService createSystemService(ClassLoader classLoader, ServletInitializationParameters initParameters) throws ServletException {
        try {
            SystemService.Builder builder = SystemService.builder().withDefaults(classLoader).setIllegalArgumentIsBackendError(initParameters.isIllegalArgumentBackendError());
            for (Class serviceClass : initParameters.getServiceClasses()) {
                builder.addService(serviceClass, this.createService(serviceClass));
            }
            return builder.build();
        }
        catch (ApiConfigException | ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected <T> T createService(Class<T> serviceClass) {
        try {
            return serviceClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format("Cannot instantiate service class: %s", serviceClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Cannot access service class: %s", serviceClass.getName()), e);
        }
    }

    private ClassLoader getUserClassLoader(ServletConfig config) throws ServletException {
        try {
            Class<?> contextClass = Class.forName("com.google.apphosting.utils.jetty.AppEngineWebAppContext$AppEngineServletContext");
            Method method = contextClass.getMethod("getClassLoader", new Class[0]);
            return (ClassLoader)method.invoke((Object)config.getServletContext(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
        catch (NoSuchMethodException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

