/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ApiKey {
    private String name;
    private String version;
    private String root;

    public ApiKey(String name, String version) {
        this(name, version, null);
    }

    public ApiKey(String name, String version, @Nullable String root) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.version = (String)Preconditions.checkNotNull((Object)version);
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getRoot() {
        return this.root;
    }

    public String getApiString() {
        return this.name + "-" + this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ApiKey) {
            ApiKey that = (ApiKey)o;
            return this.name.equals(that.name) && this.version.equals(that.version) && Objects.equals(this.root, that.root);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.root);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).add("root", (Object)this.root).toString();
    }
}

