/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.config.Transformer;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApiSerializationConfig {
    private final Map<Type, SerializerConfig> configs;

    public ApiSerializationConfig() {
        this.configs = new LinkedHashMap<Type, SerializerConfig>();
    }

    public ApiSerializationConfig(ApiSerializationConfig original) {
        this.configs = new LinkedHashMap<Type, SerializerConfig>(original.configs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiSerializationConfig) {
            ApiSerializationConfig config = (ApiSerializationConfig)o;
            return Iterables.isEmpty(this.getConfigurationInconsistencies(config));
        }
        return false;
    }

    public Iterable<ApiConfigInconsistency<Map<Type, SerializerConfig>>> getConfigurationInconsistencies(ApiSerializationConfig config) {
        return ApiConfigInconsistency.listBuilder().addIfInconsistent("serialization.configs", this.configs, config.configs).build();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public void addSerializationConfig(Class<? extends Transformer<?, ?>> serializer) {
        Type sourceType = Serializers.getSourceType(serializer);
        this.configs.put(sourceType, new SerializerConfig(sourceType, serializer));
    }

    public List<SerializerConfig> getSerializerConfigs() {
        return new ArrayList<SerializerConfig>(this.configs.values());
    }

    public SerializerConfig getSerializerConfig(Type type) {
        return this.configs.get(TypeToken.of((Type)type).getRawType());
    }

    public static class SerializerConfig {
        private final Type sourceType;
        private final Class<? extends Transformer<?, ?>> serializer;

        public SerializerConfig(Type sourceType, Class<? extends Transformer<?, ?>> serializer) {
            this.sourceType = sourceType;
            this.serializer = serializer;
        }

        public Type getSourceType() {
            return this.sourceType;
        }

        public Class<? extends Transformer<?, ?>> getSerializer() {
            return this.serializer;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SerializerConfig) {
                SerializerConfig other = (SerializerConfig)obj;
                return this.sourceType.equals(other.sourceType) && this.serializer.equals(other.serializer);
            }
            return false;
        }
    }
}

