/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import java.util.Arrays;

class ApiMethodAnnotationConfig {
    private final ApiMethodConfig config;

    public ApiMethodAnnotationConfig(ApiMethodConfig config) {
        this.config = config;
    }

    public ApiMethodConfig getConfig() {
        return this.config;
    }

    public void setNameIfNotEmpty(String name) {
        if (name != null && !name.isEmpty()) {
            this.config.setName(name);
        }
    }

    public void setPathIfNotEmpty(String path) {
        if (path != null && !path.isEmpty()) {
            this.config.setPath(path);
        }
    }

    public void setHttpMethodIfNotEmpty(String httpMethod) {
        if (httpMethod != null && !httpMethod.isEmpty()) {
            this.config.setHttpMethod(httpMethod);
        }
    }

    public void setAuthLevelIfSpecified(AuthLevel authLevel) {
        if (authLevel != AuthLevel.UNSPECIFIED) {
            this.config.setAuthLevel(authLevel);
        }
    }

    public void setScopesIfSpecified(String[] scopes) {
        if (!AnnotationUtil.isUnspecified(scopes)) {
            this.config.setScopeExpression(AuthScopeExpressions.interpret(scopes));
        }
    }

    public void setAudiencesIfSpecified(String[] audiences) {
        if (!AnnotationUtil.isUnspecified(audiences)) {
            this.config.setAudiences(Arrays.asList(audiences));
        }
    }

    public void setClientIdsIfSpecified(String[] clientIds) {
        if (!AnnotationUtil.isUnspecified(clientIds)) {
            this.config.setClientIds(Arrays.asList(clientIds));
        }
    }

    public void setAuthenticatorsIfSpecified(Class<? extends Authenticator>[] authenticators) {
        if (!AnnotationUtil.isUnspecified(authenticators)) {
            this.config.setAuthenticators(Arrays.asList(authenticators));
        }
    }

    public void setPeerAuthenticatorsIfSpecified(Class<? extends PeerAuthenticator>[] peerAuthenticators) {
        if (!AnnotationUtil.isUnspecifiedPeerAuthenticators(peerAuthenticators)) {
            this.config.setPeerAuthenticators(Arrays.asList(peerAuthenticators));
        }
    }

    public void setIgnoredIfSpecified(AnnotationBoolean ignored) {
        if (ignored == AnnotationBoolean.TRUE) {
            this.config.setIgnored(true);
        } else if (ignored == AnnotationBoolean.FALSE) {
            this.config.setIgnored(false);
        }
    }
}

