/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.swagger;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.Strings;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiKey;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiParameterConfig;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.types.DateAndTime;
import com.google.api.server.spi.types.SimpleDate;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.swagger.models.Info;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SwaggerGenerator {
    private static final String ID_TOKEN_SCHEME_NAME = "google_id_token";
    private static final Converter<String, String> CONVERTER = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static final ImmutableMap<Type, String> TYPE_TO_STRING_MAP = ImmutableMap.builder().put(String.class, (Object)"string").put(Boolean.class, (Object)"boolean").put(Boolean.TYPE, (Object)"boolean").put(Integer.class, (Object)"integer").put(Integer.TYPE, (Object)"integer").put(Long.class, (Object)"integer").put(Long.TYPE, (Object)"integer").put(Float.class, (Object)"number").put(Float.TYPE, (Object)"number").put(Double.class, (Object)"number").put(Double.TYPE, (Object)"number").put(byte[].class, (Object)"string").put(SimpleDate.class, (Object)"string").put(DateAndTime.class, (Object)"string").put(Date.class, (Object)"string").build();
    private static final ImmutableMap<Type, String> TYPE_TO_FORMAT_MAP = ImmutableMap.builder().put(Integer.class, (Object)"int32").put(Integer.TYPE, (Object)"int32").put(Long.class, (Object)"int64").put(Long.TYPE, (Object)"int64").put(Float.class, (Object)"float").put(Float.TYPE, (Object)"float").put(Double.class, (Object)"double").put(Double.TYPE, (Object)"double").put(byte[].class, (Object)"byte").put(SimpleDate.class, (Object)"date").put(DateAndTime.class, (Object)"date-time").put(Date.class, (Object)"date-time").build();
    private static final Function<ApiConfig, ApiKey> CONFIG_TO_ROOTLESS_KEY = new Function<ApiConfig, ApiKey>(){

        public ApiKey apply(ApiConfig config) {
            return new ApiKey(config.getName(), config.getVersion(), null);
        }
    };

    public Swagger writeSwagger(Iterable<ApiConfig> configs, boolean writeInternal) throws ApiConfigException {
        return this.writeSwagger(configs, false, new SwaggerContext());
    }

    public Swagger writeSwagger(Iterable<ApiConfig> configs, boolean writeInternal, SwaggerContext context) throws ApiConfigException {
        ImmutableListMultimap configsByKey = FluentIterable.from(configs).index(CONFIG_TO_ROOTLESS_KEY);
        Swagger swagger = new Swagger().produces("application/json").consumes("application/json").scheme(context.scheme).host(context.hostname).basePath(context.basePath).info(new Info().title(context.hostname).version(context.docVersion)).securityDefinition(ID_TOKEN_SCHEME_NAME, (SecuritySchemeDefinition)SwaggerGenerator.createIdTokenDefinition());
        for (ApiKey apiKey : configsByKey.keySet()) {
            this.writeApi((ImmutableList<? extends ApiConfig>)configsByKey.get((Object)apiKey), swagger, context, writeInternal);
        }
        return swagger;
    }

    private void writeApi(ImmutableList<? extends ApiConfig> apiConfigs, Swagger swagger, SwaggerContext context, boolean writeInternal) throws ApiConfigException {
        ApiConfigValidator validator = new ApiConfigValidator();
        for (ApiConfig apiConfig : apiConfigs) {
            validator.validate(apiConfig);
            this.writeApiClass(apiConfig, swagger, context, writeInternal);
        }
    }

    private void writeApiClass(ApiConfig apiConfig, Swagger swagger, SwaggerContext context, boolean writeInternal) {
        ApiClassConfig.MethodConfigMap methodConfigs = apiConfig.getApiClassConfig().getMethods();
        for (Map.Entry methodConfig : methodConfigs.entrySet()) {
            if (((ApiMethodConfig)methodConfig.getValue()).isIgnored()) continue;
            EndpointMethod endpointMethod = (EndpointMethod)methodConfig.getKey();
            ApiMethodConfig config = (ApiMethodConfig)methodConfig.getValue();
            this.writeApiMethod(config, endpointMethod, apiConfig, swagger, context, writeInternal);
        }
    }

    private void writeApiMethod(ApiMethodConfig methodConfig, EndpointMethod endpointMethod, ApiConfig apiConfig, Swagger swagger, SwaggerContext context, boolean writeInternal) {
        Path path = this.getOrCreatePath(swagger, apiConfig, methodConfig);
        Operation operation = new Operation();
        operation.setOperationId(SwaggerGenerator.getOperationId(apiConfig, methodConfig));
        Collection<String> pathParameters = methodConfig.getPathParameters();
        for (ApiParameterConfig parameterConfig : methodConfig.getParameterConfigs()) {
            switch (parameterConfig.getClassification()) {
                case API_PARAMETER: {
                    boolean required;
                    boolean isPathParameter = pathParameters.contains(parameterConfig.getName());
                    PathParameter parameter = isPathParameter ? new PathParameter() : new QueryParameter();
                    parameter.setName(parameterConfig.getName());
                    boolean bl = required = isPathParameter || !parameterConfig.getNullable() && parameterConfig.getDefaultValue() == null;
                    if (parameterConfig.isRepeated()) {
                        Type t = parameterConfig.getRepeatedItemSerializedType();
                        parameter.setType("array");
                        Property p = SwaggerGenerator.getSwaggerArrayProperty(t);
                        if (parameterConfig.isEnum()) {
                            ((StringProperty)p).setEnum(SwaggerGenerator.getEnumValues(t));
                        }
                        parameter.setItems(p);
                    } else if (parameterConfig.isEnum()) {
                        parameter.setType("string");
                        parameter.setEnum(SwaggerGenerator.getEnumValues(parameterConfig.getType()));
                        parameter.setRequired(required);
                    } else {
                        parameter.setType((String)TYPE_TO_STRING_MAP.get((Object)parameterConfig.getSchemaBaseType()));
                        parameter.setFormat((String)TYPE_TO_FORMAT_MAP.get((Object)parameterConfig.getSchemaBaseType()));
                        parameter.setRequired(required);
                    }
                    operation.parameter((Parameter)parameter);
                    break;
                }
                case RESOURCE: {
                    break;
                }
                case UNKNOWN: {
                    throw new IllegalArgumentException("Unclassifiable parameter type found.");
                }
            }
        }
        operation.response(200, new Response().description("A successful response"));
        List<String> audiences = methodConfig.getAudiences();
        if (audiences != null && audiences.size() > 0) {
            operation.addSecurity(ID_TOKEN_SCHEME_NAME, (List)ImmutableList.of());
            if (writeInternal) {
                operation.setVendorExtension("x-security", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)ID_TOKEN_SCHEME_NAME, SwaggerGenerator.createAudiences(audiences))));
            }
        }
        path.set(methodConfig.getHttpMethod().toLowerCase(), operation);
    }

    private static String getOperationId(ApiConfig apiConfig, ApiMethodConfig methodConfig) {
        return (String)CONVERTER.convert((Object)apiConfig.getName()) + (String)CONVERTER.convert((Object)methodConfig.getEndpointMethodName());
    }

    private static Property getSwaggerArrayProperty(Type type) {
        if (type == String.class) {
            return new StringProperty();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new BooleanProperty();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerProperty();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongProperty();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatProperty();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleProperty();
        }
        if (type == byte[].class) {
            return new ByteArrayProperty();
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            return new StringProperty();
        }
        throw new IllegalArgumentException("invalid property type");
    }

    private Path getOrCreatePath(Swagger swagger, ApiConfig apiConfig, ApiMethodConfig methodConfig) {
        String pathStr = "/" + apiConfig.getName() + "/" + apiConfig.getVersion() + "/" + methodConfig.getPath();
        Path path = swagger.getPath(pathStr);
        if (path == null) {
            path = new Path();
            swagger.path(pathStr, path);
        }
        return path;
    }

    private static List<String> getEnumValues(Type t) {
        ArrayList values = Lists.newArrayList();
        for (Object value : ((Class)t).getEnumConstants()) {
            values.add(value.toString());
        }
        return values;
    }

    private static Map<String, List<String>> createAudiences(List<String> audiences) {
        return ImmutableMap.of((Object)"audiences", (Object)ImmutableList.copyOf(audiences));
    }

    private static OAuth2Definition createIdTokenDefinition() {
        OAuth2Definition tokenDef = new OAuth2Definition().implicit("");
        tokenDef.setVendorExtension("x-issuer", (Object)"accounts.google.com");
        tokenDef.setVendorExtension("x-jwks_uri", (Object)"https://www.googleapis.com/oauth2/v1/certs");
        return tokenDef;
    }

    public static class SwaggerContext {
        private Scheme scheme = Scheme.HTTPS;
        private String hostname = "myapi.appspot.com";
        private String basePath = "/_ah/api";
        private String docVersion = "1.0.0";

        public SwaggerContext setApiRoot(String apiRoot) {
            try {
                URL url = new URL(apiRoot);
                this.hostname = url.getHost();
                if ("http".equals(url.getProtocol()) && url.getPort() != 80 && url.getPort() != -1 || "https".equals(url.getProtocol()) && url.getPort() != 443 && url.getPort() != -1) {
                    this.hostname = this.hostname + ":" + url.getPort();
                }
                this.basePath = Strings.stripTrailingSlash(url.getPath());
                this.setScheme(url.getProtocol());
                return this;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public SwaggerContext setScheme(String scheme) {
            this.scheme = "http".equals(scheme) ? Scheme.HTTP : Scheme.HTTPS;
            return this;
        }

        public SwaggerContext setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public SwaggerContext setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public SwaggerContext setDocVersion(String docVersion) {
            this.docVersion = docVersion;
            return this;
        }
    }
}

