/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EnvUtil;
import com.google.common.base.Strings;

public class ServiceContext {
    public static final String DEFAULT_API_NAME = "myapi";
    public static final String DEFAULT_APP_NAME = "myapp";
    private final String defaultApiName;
    private final String appHostName;

    public static ServiceContext create() {
        return ServiceContext.create(DEFAULT_APP_NAME, DEFAULT_API_NAME);
    }

    public static ServiceContext create(String applicationId, String apiName) {
        return new ServiceContext(applicationId, apiName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServiceContext(String applicationId, String apiName) {
        int colon;
        if (applicationId == null || applicationId.trim().isEmpty()) {
            applicationId = DEFAULT_APP_NAME;
        }
        if ((colon = applicationId.indexOf(":")) >= 0) {
            String appName = applicationId.substring(colon + 1);
            String string = this.defaultApiName = apiName == null ? appName : apiName;
            if (!applicationId.substring(0, colon).equals("google.com")) throw new IllegalArgumentException("Invalid application id '" + applicationId + "'");
            this.appHostName = Strings.isNullOrEmpty((String)EnvUtil.getAppHostName()) ? appName + ".googleplex.com" : EnvUtil.getAppHostName();
            return;
        } else {
            String appName = applicationId;
            this.defaultApiName = apiName == null ? appName : apiName;
            this.appHostName = Strings.isNullOrEmpty((String)EnvUtil.getAppHostName()) ? applicationId + ".appspot.com" : EnvUtil.getAppHostName();
        }
    }

    public String getDefaultApiName() {
        return this.defaultApiName;
    }

    public String getAppHostName() {
        return this.appHostName;
    }

    public String getTransferProtocol() {
        return EnvUtil.isRunningOnAppEngineProd() || !EnvUtil.isRunningOnAppEngine() ? "https" : "http";
    }
}

