/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiResourceProperty;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.Serializers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ApiAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final ApiSerializationConfig config;

    public ApiAnnotationIntrospector() {
        this(new ApiSerializationConfig());
    }

    public ApiAnnotationIntrospector(ApiSerializationConfig config) {
        this.config = config;
    }

    public boolean hasIgnoreMarker(AnnotatedMember member) {
        ApiResourceProperty apiProperty = (ApiResourceProperty)member.getAnnotation(ApiResourceProperty.class);
        return apiProperty != null && apiProperty.ignored() == AnnotationBoolean.TRUE;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        ApiResourceProperty apiName = (ApiResourceProperty)a.getAnnotation(ApiResourceProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return PropertyName.construct((String)apiName.name());
        }
        return null;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        ApiResourceProperty apiName = (ApiResourceProperty)a.getAnnotation(ApiResourceProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return PropertyName.construct((String)apiName.name());
        }
        return null;
    }

    public JsonSerializer<?> findSerializer(Annotated method) {
        return ApiAnnotationIntrospector.getJsonSerializer(this.findSerializerInstance(method));
    }

    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    @Nullable
    private static <TFrom, TTo> JsonSerializer<TFrom> getJsonSerializer(final @Nullable Transformer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        return new JsonSerializer<TFrom>(){

            public void serialize(TFrom value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeObject(serializer.transformTo(value));
            }
        };
    }

    public JsonDeserializer<?> findDeserializer(Annotated a) {
        return ApiAnnotationIntrospector.getJsonDeserializer(this.findSerializerInstance(a));
    }

    private static <TFrom, TTo> JsonDeserializer<TFrom> getJsonDeserializer(final @Nullable Transformer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        final TypeReference<TTo> serializedType = ApiAnnotationIntrospector.typeReferenceOf(serializer);
        if (serializer instanceof ResourceTransformer) {
            ResourceTransformer resourceSerializer = (ResourceTransformer)serializer;
            return new ResourceDeserializer(resourceSerializer);
        }
        return new JsonDeserializer<TFrom>(){

            public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                Object deserialized = jp.readValueAs(serializedType);
                return serializer.transformFrom(deserialized);
            }
        };
    }

    public static Type getSchemaType(Type type, ApiConfig config) {
        List<Class<Transformer<?, ?>>> serializers;
        if ((type instanceof Class || type instanceof ParameterizedType) && !(serializers = Serializers.getSerializerClasses(type, config.getSerializationConfig())).isEmpty() && !ResourceTransformer.class.isAssignableFrom(serializers.get(0))) {
            Type sourceType = Serializers.getSourceType(serializers.get(0));
            Type serializedType = Serializers.getTargetType(serializers.get(0));
            Preconditions.checkArgument((boolean)TypeToken.of((Type)sourceType).isSupertypeOf(type), (String)"Serializer specified for %s, but only serializes for %s: %s", (Object[])new Object[]{type, sourceType, serializers.get(0)});
            Preconditions.checkArgument((serializedType != null ? 1 : 0) != 0, (String)"Couldn't find Serializer interface in serializer for %s: %s", (Object[])new Object[]{type, serializers.get(0)});
            return serializedType;
        }
        return type;
    }

    @Nullable
    private Transformer<?, ?> findSerializerInstance(Annotated a) {
        AnnotatedClass clazz;
        List<Class<Transformer<?, ?>>> serializerClasses;
        if (a instanceof AnnotatedClass && !(serializerClasses = Serializers.getSerializerClasses((clazz = (AnnotatedClass)a).getRawType(), this.config)).isEmpty()) {
            return Serializers.instantiate(serializerClasses.get(0), a.getRawType());
        }
        return null;
    }

    private static <T> TypeReference<T> typeReferenceOf(Transformer<?, T> serializer) {
        Class<?> serializerClass = serializer.getClass();
        final Type type = Serializers.getTargetType(serializerClass);
        return new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        };
    }

    private static class ResourceDeserializer<TFrom>
    extends JsonDeserializer<TFrom> {
        private final ResourceTransformer<TFrom> resourceSerializer;

        private ResourceDeserializer(ResourceTransformer<TFrom> resourceSerializer) {
            this.resourceSerializer = resourceSerializer;
        }

        public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map<String, ResourcePropertySchema> properties = this.resourceSerializer.getResourceSchema().getProperties();
            ImmutableMap.Builder values = ImmutableMap.builder();
            while (jp.nextValue() != JsonToken.END_OBJECT) {
                String property = jp.getCurrentName();
                final ResourcePropertySchema schemaType = properties.get(property);
                if (schemaType != null) {
                    TypeReference<Object> jacksonTypeRef = new TypeReference<Object>(){

                        public Type getType() {
                            return schemaType.getJavaType();
                        }
                    };
                    values.put((Object)property, jp.readValueAs((TypeReference)jacksonTypeRef));
                }
                jp.skipChildren();
            }
            return this.resourceSerializer.transformFrom(values.build());
        }
    }
}

