/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.request;

import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.Strings;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.common.annotations.VisibleForTesting;
import javax.servlet.http.HttpServletRequest;

public class Attribute {
    public static final String AUTHENTICATED_APPENGINE_USER = "endpoints:Authenticated-AppEngine-User";
    public static final String API_METHOD_CONFIG = "endpoints:Api-Method-Config";
    public static final String ENABLE_CLIENT_ID_WHITELIST = "endpoints:Enable-Client-Id-Whitelist";
    public static final String RESTRICT_SERVLET = "endpoints:Restrict-Servlet";
    public static final String REQUIRE_APPENGINE_USER = "endpoints:Require-AppEngine-User";
    public static final String SKIP_TOKEN_AUTH = "endpoints:Skip-Token-Auth";
    public static final String AUTH_TOKEN = "endpoints:Auth-Token";
    private final HttpServletRequest request;

    @VisibleForTesting
    Attribute(HttpServletRequest request) {
        this.request = request;
    }

    public static Attribute from(HttpServletRequest request) {
        return new Attribute(request);
    }

    public Object get(String attr) {
        return this.request.getAttribute(attr);
    }

    public void set(String attr, Object value) {
        this.request.setAttribute(attr, value);
    }

    public void remove(String attr) {
        this.request.removeAttribute(attr);
    }

    public boolean isEnabled(String attr) {
        return this.request.getAttribute(attr) == null ? false : (Boolean)this.request.getAttribute(attr);
    }

    public static Attribute bindStandardRequestAttributes(HttpServletRequest request, ApiMethodConfig methodConfig, ServletInitializationParameters initParameters) {
        Attribute attr = Attribute.from(request);
        attr.set(RESTRICT_SERVLET, initParameters.isServletRestricted());
        attr.set(ENABLE_CLIENT_ID_WHITELIST, initParameters.isClientIdWhitelistEnabled());
        attr.set(API_METHOD_CONFIG, methodConfig);
        if (initParameters.isClientIdWhitelistEnabled() && Strings.isEmptyOrNull(methodConfig.getClientIds())) {
            attr.set(SKIP_TOKEN_AUTH, true);
        }
        return attr;
    }
}

