/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.ApiIssuer;
import com.google.api.server.spi.config.ApiIssuerAudience;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiIssuerConfigs;

public class IssuerUtil {
    private IssuerUtil() {
    }

    public static ApiIssuerConfigs toConfig(ApiIssuer[] issuerConfigs) {
        if (issuerConfigs.length == 1 && "_UNSPECIFIED_LIST_STRING_VALUE".equals(issuerConfigs[0].name())) {
            return ApiIssuerConfigs.UNSPECIFIED;
        }
        ApiIssuerConfigs.Builder builder = ApiIssuerConfigs.builder();
        for (ApiIssuer issuerConfig : issuerConfigs) {
            builder.addIssuer(new ApiIssuerConfigs.IssuerConfig(issuerConfig.name(), issuerConfig.issuer(), issuerConfig.jwksUri()));
        }
        return builder.build();
    }

    public static ApiIssuerAudienceConfig toConfig(ApiIssuerAudience[] issuers, String[] googleAudiences) {
        boolean thirdPartyIssuersUnspecified = issuers.length == 1 && "_UNSPECIFIED_LIST_STRING_VALUE".equals(issuers[0].name());
        boolean googleAudiencesUnspecified = AnnotationUtil.isUnspecified(googleAudiences);
        if (thirdPartyIssuersUnspecified && googleAudiencesUnspecified) {
            return ApiIssuerAudienceConfig.UNSPECIFIED;
        }
        ApiIssuerAudienceConfig.Builder builder = ApiIssuerAudienceConfig.builder();
        if (!thirdPartyIssuersUnspecified) {
            for (ApiIssuerAudience issuer : issuers) {
                builder.addIssuerAudiences(issuer.name(), issuer.audiences());
            }
        }
        if (!googleAudiencesUnspecified) {
            builder.addIssuerAudiences("google_id_token", googleAudiences);
        }
        return builder.build();
    }
}

