/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.AbstractResourceSchemaProvider;
import com.google.api.server.spi.config.model.ApiConfig;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class JacksonResourceSchemaProvider
extends AbstractResourceSchemaProvider {
    private static final Logger logger = Logger.getLogger(JacksonResourceSchemaProvider.class.getName());

    JacksonResourceSchemaProvider() {
    }

    @Override
    public ResourceSchema getResourceSchema(Class<?> clazz, ApiConfig config) {
        ResourceSchema schema = super.getResourceSchema(clazz, config);
        if (schema != null) {
            return schema;
        }
        ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper(config.getSerializationConfig());
        JavaType javaType = objectMapper.getTypeFactory().constructType(clazz);
        BeanDescription beanDescription = objectMapper.getSerializationConfig().introspect(javaType);
        List definitions = beanDescription.findProperties();
        ResourceSchema.Builder schemaBuilder = ResourceSchema.builderForType(clazz);
        for (BeanPropertyDefinition definition : definitions) {
            Type type = this.getPropertyType(JacksonResourceSchemaProvider.toMethod(definition.getGetter()), JacksonResourceSchemaProvider.toMethod(definition.getSetter()), definition.getField(), config);
            if (type != null) {
                schemaBuilder.addProperty(definition.getName(), ResourcePropertySchema.of(type));
                continue;
            }
            logger.warning("No type found for property " + definition.getName() + " on class " + clazz.getName());
        }
        return schemaBuilder.build();
    }

    private static Method toMethod(AnnotatedMethod am) {
        if (am != null) {
            return am.getAnnotated();
        }
        return null;
    }

    @Nullable
    private Type getPropertyType(Method readMethod, Method writeMethod, AnnotatedField field, ApiConfig config) {
        Type[] paramTypes;
        if (readMethod != null) {
            return ApiAnnotationIntrospector.getSchemaType(readMethod.getGenericReturnType(), config);
        }
        if (writeMethod != null && (paramTypes = writeMethod.getGenericParameterTypes()).length == 1) {
            return ApiAnnotationIntrospector.getSchemaType(paramTypes[0], config);
        }
        if (field != null) {
            return ApiAnnotationIntrospector.getSchemaType(field.getGenericType(), config);
        }
        return null;
    }
}

