/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiClassConfig {
    private final ApiConfig apiConfig;
    private final String apiClassJavaName;
    private final String apiClassJavaSimpleName;
    private final TypeLoader typeLoader;
    private String resource;
    private Boolean useDatastore;
    private AuthLevel authLevel;
    private AuthScopeExpression scopeExpression;
    private List<String> audiences;
    private ApiIssuerAudienceConfig issuerAudiences;
    private List<String> clientIds;
    private List<Class<? extends Authenticator>> authenticators;
    private List<Class<? extends PeerAuthenticator>> peerAuthenticators;
    private final MethodConfigMap methods;

    public ApiClassConfig(ApiConfig apiConfig, TypeLoader typeLoader, Class<?> apiClass) {
        this.apiConfig = apiConfig;
        this.apiClassJavaName = apiClass.getName();
        this.apiClassJavaSimpleName = apiClass.getSimpleName();
        this.typeLoader = typeLoader;
        this.resource = null;
        this.authLevel = AuthLevel.UNSPECIFIED;
        this.scopeExpression = null;
        this.audiences = null;
        this.issuerAudiences = ApiIssuerAudienceConfig.UNSPECIFIED;
        this.clientIds = null;
        this.authenticators = null;
        this.peerAuthenticators = null;
        this.useDatastore = null;
        this.methods = new MethodConfigMap(this);
    }

    public ApiClassConfig(ApiClassConfig original, ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
        this.apiClassJavaName = original.apiClassJavaName;
        this.apiClassJavaSimpleName = original.apiClassJavaSimpleName;
        this.typeLoader = original.typeLoader;
        this.resource = original.resource;
        this.authLevel = original.authLevel;
        this.scopeExpression = original.scopeExpression;
        this.audiences = original.audiences == null ? null : new ArrayList<String>(original.audiences);
        this.issuerAudiences = original.issuerAudiences;
        this.clientIds = original.clientIds == null ? null : new ArrayList<String>(original.clientIds);
        this.authenticators = original.authenticators == null ? null : new ArrayList<Class<? extends Authenticator>>(original.authenticators);
        this.peerAuthenticators = original.peerAuthenticators == null ? null : new ArrayList<Class<? extends PeerAuthenticator>>(original.peerAuthenticators);
        this.useDatastore = original.useDatastore;
        this.methods = new MethodConfigMap(original.methods, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiClassConfig) {
            ApiClassConfig config = (ApiClassConfig)o;
            return Objects.equals(this.apiClassJavaName, config.apiClassJavaName) && Objects.equals(this.apiClassJavaSimpleName, config.apiClassJavaSimpleName) && Objects.equals(this.typeLoader, config.typeLoader) && Objects.equals(this.resource, config.resource) && Objects.equals((Object)this.authLevel, (Object)config.authLevel) && Objects.equals(this.scopeExpression, config.scopeExpression) && Objects.equals(this.audiences, config.audiences) && Objects.equals(this.issuerAudiences, config.issuerAudiences) && Objects.equals(this.clientIds, config.clientIds) && Objects.equals(this.authenticators, config.authenticators) && Objects.equals(this.peerAuthenticators, config.peerAuthenticators) && Objects.equals(this.useDatastore, config.useDatastore) && this.methods.equals(config.methods);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiClassJavaName, this.apiClassJavaSimpleName, this.typeLoader, this.resource, this.authLevel, this.scopeExpression, this.audiences, this.clientIds, this.authenticators, this.peerAuthenticators, this.useDatastore, this.methods, this.issuerAudiences});
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public String getApiClassJavaName() {
        return this.apiClassJavaName;
    }

    public String getApiClassJavaSimpleName() {
        return this.apiClassJavaSimpleName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource != null ? this.resource : this.apiConfig.getResource();
    }

    public void setAuthLevel(AuthLevel authLevel) {
        this.authLevel = authLevel;
    }

    public AuthLevel getAuthLevel() {
        return this.authLevel != AuthLevel.UNSPECIFIED ? this.authLevel : this.apiConfig.getAuthLevel();
    }

    public void setScopeExpression(AuthScopeExpression scopeExpression) {
        this.scopeExpression = scopeExpression;
    }

    public AuthScopeExpression getScopeExpression() {
        return this.scopeExpression != null ? this.scopeExpression : this.apiConfig.getScopeExpression();
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public List<String> getAudiences() {
        return this.audiences != null ? this.audiences : this.apiConfig.getAudiences();
    }

    public void setIssuerAudiences(ApiIssuerAudienceConfig issuerAudiences) {
        Preconditions.checkNotNull((Object)issuerAudiences, (Object)"issuerAudiences should never be null");
        this.issuerAudiences = issuerAudiences;
        if (issuerAudiences.hasIssuer("google_id_token")) {
            this.getApiConfig().ensureGoogleIssuer();
        }
    }

    public ApiIssuerAudienceConfig getIssuerAudiences() {
        return this.issuerAudiences.isSpecified() ? this.issuerAudiences : this.apiConfig.getIssuerAudiences();
    }

    public void setClientIds(List<String> clientIds) {
        this.clientIds = clientIds;
    }

    public List<String> getClientIds() {
        return this.clientIds != null ? this.clientIds : this.apiConfig.getClientIds();
    }

    public void setAuthenticators(List<Class<? extends Authenticator>> authenticators) {
        this.authenticators = authenticators;
    }

    public List<Class<? extends Authenticator>> getAuthenticators() {
        return this.authenticators != null ? this.authenticators : this.apiConfig.getAuthenticators();
    }

    public void setPeerAuthenticators(List<Class<? extends PeerAuthenticator>> peerAuthenticators) {
        this.peerAuthenticators = peerAuthenticators;
    }

    public List<Class<? extends PeerAuthenticator>> getPeerAuthenticators() {
        return this.peerAuthenticators != null ? this.peerAuthenticators : this.apiConfig.getPeerAuthenticators();
    }

    public void setUseDatastore(boolean useDatastore) {
        this.useDatastore = useDatastore;
    }

    public boolean getUseDatastore() {
        return this.useDatastore != null ? this.useDatastore.booleanValue() : this.apiConfig.getUseDatastore();
    }

    public MethodConfigMap getMethods() {
        return this.methods;
    }

    public static class MethodConfigMap
    extends LinkedHashMap<EndpointMethod, ApiMethodConfig> {
        private final ApiClassConfig apiClassConfig;

        protected MethodConfigMap(ApiClassConfig apiClassConfig) {
            this.apiClassConfig = apiClassConfig;
        }

        protected MethodConfigMap(MethodConfigMap original, ApiClassConfig apiClassConfig) {
            this.apiClassConfig = apiClassConfig;
            for (Map.Entry entry : original.entrySet()) {
                this.put(entry.getKey(), new ApiMethodConfig((ApiMethodConfig)entry.getValue(), apiClassConfig));
            }
        }

        public ApiMethodConfig getOrCreate(EndpointMethod method) {
            if (this.containsKey(method)) {
                return (ApiMethodConfig)this.get(method);
            }
            ApiMethodConfig methodConfig = this.createMethodConfig(method, this.apiClassConfig.typeLoader, this.apiClassConfig);
            this.put(method, methodConfig);
            return methodConfig;
        }

        protected ApiMethodConfig createMethodConfig(EndpointMethod method, TypeLoader typeLoader, ApiClassConfig apiClassConfig) {
            return new ApiMethodConfig(method, typeLoader, apiClassConfig);
        }

        public ApiClassConfig getApiClassConfig() {
            return this.apiClassConfig;
        }
    }
}

