/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.types;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Objects;

public class SimpleDate {
    private int year;
    private int month;
    private int day;

    public SimpleDate(int year, int month, int day) {
        Preconditions.checkArgument((year >= 1 && year <= 9999 ? 1 : 0) != 0, (Object)"Only year values between 1 and 9999 are supported.");
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(year, month - 1, day, 0, 0, 0);
        calendar.getTime();
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleDate)) {
            return false;
        }
        SimpleDate other = (SimpleDate)obj;
        return this.year == other.year && this.month == other.month && this.day == other.day;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day);
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }
}

