/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.request;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.api.client.util.DateTime;
import com.google.api.server.spi.ConfiguredObjectMapper;
import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Named;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.StandardParameters;
import com.google.api.server.spi.request.AbstractParamReader;
import com.google.api.server.spi.request.Auth;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.types.DateAndTime;
import com.google.api.server.spi.types.SimpleDate;
import com.google.appengine.api.datastore.Blob;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestParamReader
extends AbstractParamReader {
    private static final Logger logger = Logger.getLogger(ServletRequestParamReader.class.getName());
    private static final Set<SimpleModule> READER_MODULES;
    protected final HttpServletRequest servletRequest;
    private final ServletContext servletContext;
    protected final ObjectReader objectReader;

    protected static List<String> getParameterNames(EndpointMethod endpointMethod) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List<String> parameterNames = endpointMethod.getParameterNames();
        if (parameterNames == null) {
            Method method = endpointMethod.getMethod();
            parameterNames = new ArrayList<String>();
            for (int parameter = 0; parameter < method.getParameterTypes().length; ++parameter) {
                Annotation annotation = AnnotationUtil.getNamedParameter(method, parameter, Named.class);
                if (annotation == null) {
                    parameterNames.add(null);
                    continue;
                }
                parameterNames.add((String)annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]));
            }
            endpointMethod.setParameterNames(parameterNames);
        }
        return parameterNames;
    }

    protected Object[] deserializeParams(JsonNode node) throws IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        EndpointMethod method = this.getMethod();
        Class<?>[] paramClasses = method.getParameterClasses();
        TypeToken<?>[] paramTypes = method.getParameterTypes();
        Object[] params = new Object[paramClasses.length];
        List<String> parameterNames = ServletRequestParamReader.getParameterNames(method);
        for (int i = 0; i < paramClasses.length; ++i) {
            TypeToken<?> type = paramTypes[i];
            Class<?> clazz = paramClasses[i];
            if (clazz == User.class) {
                params[i] = this.getUser();
                logger.log(Level.FINE, "deserialize: User injected into param[{0}]", i);
                continue;
            }
            if (clazz == com.google.appengine.api.users.User.class) {
                params[i] = this.getAppEngineUser();
                logger.log(Level.FINE, "deserialize: App Engine User injected into param[{0}]", i);
                continue;
            }
            if (clazz == HttpServletRequest.class) {
                params[i] = this.servletRequest;
                logger.log(Level.FINE, "deserialize: HttpServletRequest injected into param[{0}]", i);
                continue;
            }
            if (clazz == ServletContext.class) {
                params[i] = this.servletContext;
                logger.log(Level.FINE, "deserialize: ServletContext {0} injected into param[{1}]", new Object[]{params[i], i});
                continue;
            }
            String name = parameterNames.get(i);
            if (Strings.isNullOrEmpty((String)name)) {
                params[i] = node == null ? null : this.objectReader.forType(clazz).readValue(node);
                logger.log(Level.FINE, "deserialize: {0} {1} injected into unnamed param[{2}]", new Object[]{clazz, params[i], i});
                continue;
            }
            if (StandardParameters.isStandardParamName(name)) {
                params[i] = this.getStandardParamValue(node, name);
                continue;
            }
            JsonNode nodeValue = node.get(name);
            params[i] = nodeValue == null ? null : (Collection.class.isAssignableFrom(clazz) && type.getType() instanceof ParameterizedType ? this.deserializeCollection(clazz, (ParameterizedType)type.getType(), nodeValue) : this.objectReader.forType(clazz).readValue(nodeValue));
            logger.log(Level.FINE, "deserialize: {0} {1} injected into param[{2}] named {3}", new Object[]{clazz, params[i], i, name});
        }
        return params;
    }

    @VisibleForTesting
    User getUser() {
        return Auth.from(this.servletRequest).authenticate();
    }

    @VisibleForTesting
    com.google.appengine.api.users.User getAppEngineUser() {
        return Auth.from(this.servletRequest).authenticateAppEngineUser();
    }

    private Object getStandardParamValue(JsonNode body, String paramName) {
        if (!StandardParameters.isStandardParamName(paramName)) {
            throw new IllegalArgumentException("paramName");
        }
        if ("userIp".equals(paramName)) {
            return this.servletRequest.getRemoteAddr();
        }
        if ("prettyPrint".equals(paramName)) {
            return StandardParameters.shouldPrettyPrint(this.servletRequest);
        }
        JsonNode value = body.get(paramName);
        if (value == null && "alt".equals(paramName)) {
            return "json";
        }
        return value != null ? value.asText() : null;
    }

    private <T> Collection<T> deserializeCollection(Class<?> clazz, ParameterizedType collectionType, JsonNode nodeValue) throws IOException {
        Class<?> collectionClass = clazz;
        Class<?> paramClass = EndpointMethod.getClassFromType(collectionType.getActualTypeArguments()[0]);
        Class<?> arrayClazz = Array.newInstance(paramClass, 0).getClass();
        Collection collection = (Collection)this.objectReader.forType(collectionClass).readValue(this.objectReader.createArrayNode());
        if (nodeValue != null) {
            Object[] array = (Object[])this.objectReader.forType(arrayClazz).readValue(nodeValue);
            collection.addAll(Arrays.asList(array));
        }
        return collection;
    }

    public ServletRequestParamReader(EndpointMethod method, HttpServletRequest servletRequest, ServletContext servletContext, ApiSerializationConfig serializationConfig) {
        super(method);
        this.servletRequest = servletRequest;
        this.servletContext = servletContext;
        LinkedHashSet<SimpleModule> modules = new LinkedHashSet<SimpleModule>();
        modules.addAll(READER_MODULES);
        this.objectReader = ConfiguredObjectMapper.builder().apiSerializationConfig(serializationConfig).addRegisteredModules(modules).build().reader();
    }

    @Override
    public Object[] read() throws BadRequestException {
        try {
            String requestBody = IoUtil.readStream((InputStream)this.servletRequest.getInputStream());
            logger.log(Level.FINE, "requestBody=" + requestBody);
            if (requestBody == null || requestBody.trim().isEmpty()) {
                return new Object[0];
            }
            JsonNode node = this.objectReader.readTree(requestBody);
            return this.deserializeParams(node);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadRequestException(e);
        }
    }

    static {
        LinkedHashSet<SimpleModule> modules = new LinkedHashSet<SimpleModule>();
        SimpleModule dateModule = new SimpleModule("dateModule", new Version(1, 0, 0, null, null, null));
        dateModule.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        modules.add(dateModule);
        SimpleModule simpleDateModule = new SimpleModule("simpleDateModule", new Version(1, 0, 0, null, null, null));
        simpleDateModule.addDeserializer(SimpleDate.class, (JsonDeserializer)new SimpleDateDeserializer());
        modules.add(simpleDateModule);
        SimpleModule dateAndTimeModule = new SimpleModule("dateAndTimeModule", new Version(1, 0, 0, null, null, null));
        dateAndTimeModule.addDeserializer(DateAndTime.class, (JsonDeserializer)new DateAndTimeDeserializer());
        modules.add(dateAndTimeModule);
        SimpleModule blobModule = new SimpleModule("blobModule", new Version(1, 0, 0, null, null, null));
        blobModule.addDeserializer(Blob.class, (JsonDeserializer)new BlobDeserializer());
        modules.add(blobModule);
        READER_MODULES = Collections.unmodifiableSet(modules);
    }

    private static class BlobDeserializer
    extends JsonDeserializer<Blob> {
        private BlobDeserializer() {
        }

        public Blob deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return new Blob(jsonParser.getBinaryValue());
        }
    }

    private static class SimpleDateDeserializer
    extends JsonDeserializer<SimpleDate> {
        Pattern pattern = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})$");

        private SimpleDateDeserializer() {
        }

        public SimpleDate deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            String value = ((String)jsonParser.readValueAs(String.class)).trim();
            Matcher matcher = this.pattern.matcher(value);
            if (matcher.find()) {
                int year = Integer.parseInt(matcher.group(1));
                int month = Integer.parseInt(matcher.group(2));
                int day = Integer.parseInt(matcher.group(3));
                return new SimpleDate(year, month, day);
            }
            throw new IllegalArgumentException("String is not an RFC3339 formated date (yyyy-mm-dd): " + value);
        }
    }

    private static class DateAndTimeDeserializer
    extends JsonDeserializer<DateAndTime> {
        private DateAndTimeDeserializer() {
        }

        public DateAndTime deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return DateAndTime.parseRfc3339String((String)jsonParser.readValueAs(String.class));
        }
    }

    private static class DateDeserializer
    extends JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            DateTime date = new DateTime((String)jsonParser.readValueAs(String.class));
            return new Date(date.getValue());
        }
    }
}

