/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EnvUtil;

public class ServiceContext {
    public static final String DEFAULT_API_NAME = "myapi";
    public static final String DEFAULT_APP_NAME = "myapp";
    private final String defaultApiName;
    private final String appHostname;

    public static ServiceContext create() {
        return ServiceContext.create(DEFAULT_APP_NAME, DEFAULT_API_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceContext create(String applicationId, String apiName) {
        int colon;
        String hostname = null;
        String defaultApiName = null;
        if (applicationId == null || applicationId.trim().isEmpty()) {
            applicationId = DEFAULT_APP_NAME;
        }
        if ((colon = applicationId.indexOf(":")) >= 0) {
            String appName = applicationId.substring(colon + 1);
            String string = defaultApiName = apiName == null ? appName : apiName;
            if (!applicationId.substring(0, colon).equals("google.com")) throw new IllegalArgumentException("Invalid application id '" + applicationId + "'");
            hostname = appName + ".googleplex.com";
            return new ServiceContext(hostname, defaultApiName);
        } else {
            defaultApiName = apiName == null ? applicationId : apiName;
            hostname = applicationId + ".appspot.com";
        }
        return new ServiceContext(hostname, defaultApiName);
    }

    public static ServiceContext createFromHostname(String hostname, String apiName) {
        return new ServiceContext(hostname, apiName);
    }

    private ServiceContext(String appHostname, String defaultApiName) {
        this.appHostname = appHostname;
        this.defaultApiName = defaultApiName;
    }

    public String getDefaultApiName() {
        return this.defaultApiName;
    }

    public String getAppHostname() {
        return this.appHostname;
    }

    public String getTransferProtocol() {
        return EnvUtil.isRunningOnAppEngineProd() || !EnvUtil.isRunningOnAppEngine() ? "https" : "http";
    }
}

