/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.client.util.Maps;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.JacksonResourceSchemaProvider;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.FieldType;
import com.google.api.server.spi.config.model.Schema;
import com.google.api.server.spi.config.model.Types;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaRepository {
    private static final Schema PLACEHOLDER_SCHEMA = Schema.builder().setName("_placeholder_").setType("_placeholder_").build();
    @VisibleForTesting
    static final Schema ANY_SCHEMA = Schema.builder().setName("_any").setType("any").build();
    @VisibleForTesting
    static final Schema MAP_SCHEMA = Schema.builder().setName("JsonMap").setType("object").build();
    @VisibleForTesting
    static final String ARRAY_UNUSED_MSG = "unused for array items";
    private final Multimap<ApiKey, Schema> schemaByApiKeys = LinkedHashMultimap.create();
    private final Map<ApiSerializationConfig, Map<TypeToken<?>, Schema>> types = Maps.newHashMap();
    private final ResourceSchemaProvider resourceSchemaProvider = new JacksonResourceSchemaProvider();
    private final TypeLoader typeLoader;

    public SchemaRepository(TypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    public Schema get(TypeToken<?> type, ApiConfig config) {
        Map<TypeToken<?>, Schema> typesForConfig = this.getAllTypesForConfig(config);
        Schema schema = typesForConfig.get(type = ApiAnnotationIntrospector.getSchemaType(type, config));
        if (schema != null) {
            if (schema == PLACEHOLDER_SCHEMA) {
                throw new IllegalStateException("schema repository is in a bad state!");
            }
            return schema;
        }
        return null;
    }

    public Schema getOrAdd(TypeToken<?> type, ApiConfig config) {
        Map<TypeToken<?>, Schema> typesForConfig = this.getAllTypesForConfig(config);
        Schema schema = this.getOrCreateTypeForConfig(type, typesForConfig, config);
        if (schema == PLACEHOLDER_SCHEMA) {
            throw new IllegalStateException("schema repository is in a bad state!");
        }
        return schema;
    }

    public List<Schema> getAllSchemaForApi(ApiKey apiKey) {
        return ImmutableList.copyOf((Collection)this.schemaByApiKeys.get((Object)apiKey.withoutRoot()));
    }

    private Map<TypeToken<?>, Schema> getAllTypesForConfig(ApiConfig config) {
        HashMap typesForConfig = this.types.get(config.getSerializationConfig());
        if (typesForConfig == null) {
            typesForConfig = Maps.newHashMap();
            this.types.put(config.getSerializationConfig(), typesForConfig);
        }
        return typesForConfig;
    }

    private Schema getOrCreateTypeForConfig(TypeToken type, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        type = ApiAnnotationIntrospector.getSchemaType(type, config);
        Schema schema = typesForConfig.get(type);
        ApiKey key = config.getApiKey().withoutRoot();
        if (schema != null) {
            if (schema != PLACEHOLDER_SCHEMA) {
                this.addSchemaToApi(key, schema);
            }
            return schema;
        }
        typesForConfig.put(type, PLACEHOLDER_SCHEMA);
        TypeToken<?> arrayItemType = Types.getArrayItemType(type);
        if (this.typeLoader.isSchemaType(type)) {
            throw new IllegalArgumentException("Can't add a primitive type as a resource");
        }
        if (arrayItemType != null) {
            Schema.Field.Builder arrayItemSchema = Schema.Field.builder().setName(ARRAY_UNUSED_MSG);
            this.fillInFieldInformation(arrayItemSchema, arrayItemType, typesForConfig, config);
            schema = Schema.builder().setName(Types.getSimpleName(type, config.getSerializationConfig())).setType("object").addField("items", Schema.Field.builder().setName("items").setType(FieldType.ARRAY).setArrayItemSchema(arrayItemSchema.build()).build()).build();
            typesForConfig.put(type, schema);
            this.schemaByApiKeys.put((Object)key, (Object)schema);
            return schema;
        }
        if (Types.isObject(type)) {
            typesForConfig.put(type, ANY_SCHEMA);
            this.schemaByApiKeys.put((Object)key, (Object)ANY_SCHEMA);
            return ANY_SCHEMA;
        }
        if (Types.isMapType(type)) {
            typesForConfig.put(type, MAP_SCHEMA);
            this.schemaByApiKeys.put((Object)key, (Object)MAP_SCHEMA);
            return MAP_SCHEMA;
        }
        if (Types.isEnumType(type)) {
            Schema.Builder builder = Schema.builder().setName(Types.getSimpleName(type, config.getSerializationConfig())).setType("string");
            for (Object enumConstant : type.getRawType().getEnumConstants()) {
                builder.addEnumValue(enumConstant.toString());
                builder.addEnumDescription("");
            }
            schema = builder.build();
            typesForConfig.put(type, schema);
            this.schemaByApiKeys.put((Object)key, (Object)schema);
            return schema;
        }
        schema = this.createBeanSchema(type, typesForConfig, config);
        typesForConfig.put(type, schema);
        this.schemaByApiKeys.put((Object)key, (Object)schema);
        return schema;
    }

    private void addSchemaToApi(ApiKey key, Schema schema) {
        if (this.schemaByApiKeys.containsEntry((Object)key, (Object)schema)) {
            return;
        }
        this.schemaByApiKeys.put((Object)key, (Object)schema);
        for (Schema.Field f : schema.fields().values()) {
            while (f.type() == FieldType.ARRAY) {
                f = f.arrayItemSchema();
            }
            if (f.type() != FieldType.OBJECT && f.type() != FieldType.ENUM) continue;
            this.addSchemaToApi(key, f.schemaReference().get());
        }
    }

    private Schema createBeanSchema(TypeToken<?> type, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        Schema.Builder builder = Schema.builder().setName(Types.getSimpleName(type, config.getSerializationConfig())).setType("object");
        ResourceSchema schema = this.resourceSchemaProvider.getResourceSchema(type, config);
        for (Map.Entry<String, ResourcePropertySchema> entry : schema.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            TypeToken<?> propertyType = entry.getValue().getType();
            if (propertyType == null) continue;
            Schema.Field.Builder fieldBuilder = Schema.Field.builder().setName(propertyName);
            this.fillInFieldInformation(fieldBuilder, propertyType, typesForConfig, config);
            builder.addField(propertyName, fieldBuilder.build());
        }
        return builder.build();
    }

    private void fillInFieldInformation(Schema.Field.Builder builder, TypeToken<?> fieldType, Map<TypeToken<?>, Schema> typesForConfig, ApiConfig config) {
        FieldType ft = FieldType.fromType(fieldType);
        builder.setType(ft);
        if (ft == FieldType.OBJECT || ft == FieldType.ENUM) {
            this.getOrCreateTypeForConfig(fieldType, typesForConfig, config);
            builder.setSchemaReference(Schema.SchemaReference.create(this, config, fieldType));
        } else if (ft == FieldType.ARRAY) {
            Schema.Field.Builder arrayItemBuilder = Schema.Field.builder().setName(ARRAY_UNUSED_MSG);
            this.fillInFieldInformation(arrayItemBuilder, ApiAnnotationIntrospector.getSchemaType(Types.getArrayItemType(fieldType), config), typesForConfig, config);
            builder.setArrayItemSchema(arrayItemBuilder.build());
        }
    }
}

