/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.discovery.DiscoveryGenerator;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.common.collect.ImmutableMap;

final class AutoValue_DiscoveryGenerator_Result
extends DiscoveryGenerator.Result {
    private final DirectoryList directory;
    private final ImmutableMap<ApiKey, RestDescription> discoveryDocs;

    private AutoValue_DiscoveryGenerator_Result(DirectoryList directory, ImmutableMap<ApiKey, RestDescription> discoveryDocs) {
        if (directory == null) {
            throw new NullPointerException("Null directory");
        }
        this.directory = directory;
        if (discoveryDocs == null) {
            throw new NullPointerException("Null discoveryDocs");
        }
        this.discoveryDocs = discoveryDocs;
    }

    @Override
    public DirectoryList directory() {
        return this.directory;
    }

    @Override
    public ImmutableMap<ApiKey, RestDescription> discoveryDocs() {
        return this.discoveryDocs;
    }

    public String toString() {
        return "Result{directory=" + (Object)((Object)this.directory) + ", discoveryDocs=" + this.discoveryDocs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DiscoveryGenerator.Result) {
            DiscoveryGenerator.Result that = (DiscoveryGenerator.Result)o;
            return this.directory.equals((Object)that.directory()) && this.discoveryDocs.equals(that.discoveryDocs());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.directory.hashCode();
        h *= 1000003;
        return h ^= this.discoveryDocs.hashCode();
    }

    static final class Builder
    extends DiscoveryGenerator.Result.Builder {
        private DirectoryList directory;
        private ImmutableMap<ApiKey, RestDescription> discoveryDocs;

        Builder() {
        }

        Builder(DiscoveryGenerator.Result source) {
            this.directory = source.directory();
            this.discoveryDocs = source.discoveryDocs();
        }

        @Override
        public DiscoveryGenerator.Result.Builder setDirectory(DirectoryList directory) {
            this.directory = directory;
            return this;
        }

        @Override
        public DiscoveryGenerator.Result.Builder setDiscoveryDocs(ImmutableMap<ApiKey, RestDescription> discoveryDocs) {
            this.discoveryDocs = discoveryDocs;
            return this;
        }

        @Override
        public DiscoveryGenerator.Result build() {
            String missing = "";
            if (this.directory == null) {
                missing = missing + " directory";
            }
            if (this.discoveryDocs == null) {
                missing = missing + " discoveryDocs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DiscoveryGenerator_Result(this.directory, this.discoveryDocs);
        }
    }
}

