/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.server.spi.Client;
import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.auth.GoogleJwtAuthenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class EndpointsPeerAuthenticator
implements PeerAuthenticator {
    @VisibleForTesting
    static final String ISSUER = "https://www.cloudendpointsapis.com";
    @VisibleForTesting
    static final String SIGNER = "cloud-endpoints-signer@system.gserviceaccount.com";
    @VisibleForTesting
    static final String HEADER_APPENGINE_PEER = "X-Appengine-Peer";
    @VisibleForTesting
    static final String APPENGINE_PEER = "apiserving";
    @VisibleForTesting
    static final String HEADER_PEER_AUTHORIZATION = "Peer-Authorization";
    private static final String PUBLIC_CERT_URL = "https://www.googleapis.com/service_accounts/v1/metadata/x509/cloud-endpoints-signer@system.gserviceaccount.com";
    private static final Logger logger = Logger.getLogger(EndpointsPeerAuthenticator.class.getName());
    private static final ImmutableSet<String> localHostAddresses = EndpointsPeerAuthenticator.getLocalHostAddresses();
    private final GoogleJwtAuthenticator jwtAuthenticator;

    private static ImmutableSet<String> getLocalHostAddresses() {
        ImmutableSet localHostSet;
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        try {
            builder.add((Object)InetAddress.getLocalHost().getHostAddress());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            builder.add((Object)InetAddress.getByName(null).getHostAddress());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            for (InetAddress inetAddress : InetAddress.getAllByName("localhost")) {
                builder.add((Object)inetAddress.getHostAddress());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((localHostSet = builder.build()).isEmpty()) {
            logger.warning("Unable to lookup local addresses.");
        }
        return localHostSet;
    }

    public EndpointsPeerAuthenticator() {
        Client client = Client.getInstance();
        GooglePublicKeysManager keyManager = new GooglePublicKeysManager.Builder(client.getHttpTransport(), client.getJsonFactory()).setPublicCertsEncodedUrl(PUBLIC_CERT_URL).build();
        GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder(keyManager).setIssuer(ISSUER).build();
        this.jwtAuthenticator = new GoogleJwtAuthenticator(verifier);
    }

    @VisibleForTesting
    public EndpointsPeerAuthenticator(GoogleJwtAuthenticator jwtAuthenticator) {
        this.jwtAuthenticator = jwtAuthenticator;
    }

    @Override
    public boolean authenticate(HttpServletRequest request) {
        if (EnvUtil.isRunningOnAppEngine()) {
            return APPENGINE_PEER.equals(request.getHeader(HEADER_APPENGINE_PEER));
        }
        if (localHostAddresses.contains((Object)request.getRemoteAddr())) {
            logger.fine("Skip endpoints peer verication from localhost.");
            return true;
        }
        GoogleIdToken idToken = this.jwtAuthenticator.verifyToken(request.getHeader(HEADER_PEER_AUTHORIZATION));
        return idToken != null && SIGNER.equals(idToken.getPayload().getEmail()) && this.matchHostAndPort(idToken, request);
    }

    private boolean matchHostAndPort(GoogleIdToken idToken, HttpServletRequest request) {
        try {
            URL urlFromIdToken = new URL((String)idToken.getPayload().getAudience());
            URL urlFromRequest = new URL(request.getRequestURL().toString());
            return urlFromIdToken.getHost().equals(urlFromRequest.getHost()) && this.getPort(urlFromIdToken) == this.getPort(urlFromRequest);
        }
        catch (MalformedURLException e) {
            logger.warning("Invalid URL from request");
            return false;
        }
    }

    private int getPort(URL url) {
        int port = url.getPort();
        return port == -1 ? url.getDefaultPort() : port;
    }
}

