/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.swagger;

import com.google.api.server.spi.Strings;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiIssuerConfigs;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.ApiLimitMetricConfig;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiMetricCostConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.FieldType;
import com.google.api.server.spi.config.model.Schema;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.types.DateAndTime;
import com.google.api.server.spi.types.SimpleDate;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SwaggerGenerator {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final String API_KEY = "api_key";
    private static final String API_KEY_PARAM = "key";
    private static final String MANAGEMENT_DEFINITIONS_KEY = "x-google-management";
    private static final String LIMITS_KEY = "limits";
    private static final String LIMIT_NAME_KEY = "name";
    private static final String LIMIT_METRIC_KEY = "metric";
    private static final String LIMIT_DISPLAY_NAME_KEY = "displayName";
    private static final String LIMIT_DEFAULT_LIMIT_KEY = "values";
    private static final String LIMIT_UNIT_KEY = "unit";
    private static final String LIMIT_PER_MINUTE_PER_PROJECT = "1/min/{project}";
    private static final String METRIC_NAME_KEY = "name";
    private static final String METRIC_VALUE_TYPE_KEY = "valueType";
    private static final String METRIC_VALUE_TYPE = "INT64";
    private static final String METRIC_KIND_KEY = "metricKind";
    private static final String METRIC_KIND = "GAUGE";
    private static final String METRICS_KEY = "metrics";
    private static final String QUOTA_KEY = "quota";
    private static final Converter<String, String> CONVERTER = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL);
    private static final ImmutableMap<Type, String> TYPE_TO_STRING_MAP = ImmutableMap.builder().put(String.class, (Object)"string").put(Boolean.class, (Object)"boolean").put(Boolean.TYPE, (Object)"boolean").put(Integer.class, (Object)"integer").put(Integer.TYPE, (Object)"integer").put(Long.class, (Object)"integer").put(Long.TYPE, (Object)"integer").put(Float.class, (Object)"number").put(Float.TYPE, (Object)"number").put(Double.class, (Object)"number").put(Double.TYPE, (Object)"number").put(byte[].class, (Object)"string").put(SimpleDate.class, (Object)"string").put(DateAndTime.class, (Object)"string").put(Date.class, (Object)"string").build();
    private static final ImmutableMap<Type, String> TYPE_TO_FORMAT_MAP = ImmutableMap.builder().put(Integer.class, (Object)"int32").put(Integer.TYPE, (Object)"int32").put(Long.class, (Object)"int64").put(Long.TYPE, (Object)"int64").put(Float.class, (Object)"float").put(Float.TYPE, (Object)"float").put(Double.class, (Object)"double").put(Double.TYPE, (Object)"double").put(byte[].class, (Object)"byte").put(SimpleDate.class, (Object)"date").put(DateAndTime.class, (Object)"date-time").put(Date.class, (Object)"date-time").build();
    private static final ImmutableMap<FieldType, Property> FIELD_TYPE_TO_PROPERTY_MAP = ImmutableMap.builder().put((Object)FieldType.BOOLEAN, (Object)new BooleanProperty()).put((Object)FieldType.BYTE_STRING, (Object)new ByteArrayProperty()).put((Object)FieldType.DATE, (Object)new DateProperty()).put((Object)FieldType.DATE_TIME, (Object)new DateTimeProperty()).put((Object)FieldType.DOUBLE, (Object)new DoubleProperty()).put((Object)FieldType.FLOAT, (Object)new FloatProperty()).put((Object)FieldType.INT8, (Object)new IntegerProperty()).put((Object)FieldType.INT16, (Object)new IntegerProperty()).put((Object)FieldType.INT32, (Object)new IntegerProperty()).put((Object)FieldType.INT64, (Object)new LongProperty()).put((Object)FieldType.STRING, (Object)new StringProperty()).build();
    private static final Function<ApiConfig, ApiKey> CONFIG_TO_ROOTLESS_KEY = new Function<ApiConfig, ApiKey>(){

        public ApiKey apply(ApiConfig config) {
            return new ApiKey(config.getName(), config.getVersion(), null);
        }
    };

    public Swagger writeSwagger(Iterable<ApiConfig> configs, boolean writeInternal, SwaggerContext context) throws ApiConfigException {
        try {
            TypeLoader typeLoader = new TypeLoader(SwaggerGenerator.class.getClassLoader());
            SchemaRepository repo = new SchemaRepository(typeLoader);
            GenerationContext genCtx = new GenerationContext();
            genCtx.validator = new ApiConfigValidator(typeLoader, repo);
            genCtx.writeInternal = writeInternal;
            genCtx.schemata = new SchemaRepository(typeLoader);
            return this.writeSwagger(configs, context, genCtx);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Swagger writeSwagger(Iterable<ApiConfig> configs, SwaggerContext context, GenerationContext genCtx) throws ApiConfigException {
        ImmutableListMultimap configsByKey = FluentIterable.from(configs).index(CONFIG_TO_ROOTLESS_KEY);
        Swagger swagger = new Swagger().produces("application/json").consumes("application/json").scheme(context.scheme).host(context.hostname).basePath(context.basePath).info(new Info().title(context.hostname).version(context.docVersion));
        for (ApiKey apiKey : configsByKey.keySet()) {
            this.writeApi(apiKey, (ImmutableList<? extends ApiConfig>)configsByKey.get((Object)apiKey), swagger, genCtx);
        }
        this.writeQuotaDefinitions(swagger, genCtx);
        return swagger;
    }

    private void writeQuotaDefinitions(Swagger swagger, GenerationContext genCtx) {
        if (!genCtx.limitMetrics.isEmpty()) {
            HashMap quotaDefinitions = new HashMap();
            ArrayList<ImmutableMap> limits = new ArrayList<ImmutableMap>();
            ArrayList<ImmutableMap> metrics = new ArrayList<ImmutableMap>();
            for (ApiLimitMetricConfig limitMetric : genCtx.limitMetrics.values()) {
                metrics.add(ImmutableMap.builder().put((Object)"name", (Object)limitMetric.name()).put((Object)METRIC_VALUE_TYPE_KEY, (Object)METRIC_VALUE_TYPE).put((Object)METRIC_KIND_KEY, (Object)METRIC_KIND).build());
                ImmutableMap.Builder limitBuilder = ImmutableMap.builder().put((Object)"name", (Object)limitMetric.name()).put((Object)LIMIT_METRIC_KEY, (Object)limitMetric.name()).put((Object)LIMIT_DEFAULT_LIMIT_KEY, (Object)ImmutableMap.of((Object)"STANDARD", (Object)limitMetric.limit())).put((Object)LIMIT_UNIT_KEY, (Object)LIMIT_PER_MINUTE_PER_PROJECT);
                if (limitMetric.displayName() != null && !"".equals(limitMetric.displayName())) {
                    limitBuilder.put((Object)LIMIT_DISPLAY_NAME_KEY, (Object)limitMetric.displayName());
                }
                limits.add(limitBuilder.build());
            }
            quotaDefinitions.put(LIMITS_KEY, limits);
            swagger.setVendorExtension(MANAGEMENT_DEFINITIONS_KEY, (Object)ImmutableMap.of((Object)METRICS_KEY, metrics, (Object)QUOTA_KEY, quotaDefinitions));
        }
    }

    private void writeApi(ApiKey apiKey, ImmutableList<? extends ApiConfig> apiConfigs, Swagger swagger, GenerationContext genCtx) throws ApiConfigException {
        genCtx.validator.validate((Iterable<? extends ApiConfig>)apiConfigs);
        for (ApiConfig apiConfig : apiConfigs) {
            for (ApiLimitMetricConfig limitMetric : apiConfig.getApiLimitMetrics()) {
                this.addNonConflictingApiLimitMetric(genCtx.limitMetrics, limitMetric);
            }
            this.writeApiClass(apiConfig, swagger, genCtx);
        }
        List<Schema> schemas = genCtx.schemata.getAllSchemaForApi(apiKey);
        if (!schemas.isEmpty()) {
            for (Schema schema : schemas) {
                swagger.addDefinition(schema.name(), this.convertToSwaggerSchema(schema));
            }
        }
    }

    private void addNonConflictingApiLimitMetric(Map<String, ApiLimitMetricConfig> limitMetrics, ApiLimitMetricConfig limitMetric) throws ApiConfigException {
        if (limitMetric.equals(limitMetrics.get(limitMetric.name()))) {
            throw new ApiConfigException(String.format("Multiple limit metric definitions found for metric %s. Metric definitions must have unique names for all APIs included in the OpenAPI document, or they must have identical definitions.", limitMetric.name()));
        }
        limitMetrics.put(limitMetric.name(), limitMetric);
    }

    private void writeApiClass(ApiConfig apiConfig, Swagger swagger, GenerationContext genCtx) throws ApiConfigException {
        ApiClassConfig.MethodConfigMap methodConfigs = apiConfig.getApiClassConfig().getMethods();
        for (Map.Entry methodConfig : methodConfigs.entrySet()) {
            if (((ApiMethodConfig)methodConfig.getValue()).isIgnored()) continue;
            ApiMethodConfig config = (ApiMethodConfig)methodConfig.getValue();
            this.writeApiMethod(config, apiConfig, swagger, genCtx);
        }
    }

    private void writeApiMethod(ApiMethodConfig methodConfig, ApiConfig apiConfig, Swagger swagger, GenerationContext genCtx) throws ApiConfigException {
        Path path = this.getOrCreatePath(swagger, methodConfig);
        Operation operation = new Operation();
        operation.setOperationId(SwaggerGenerator.getOperationId(apiConfig, methodConfig));
        operation.setDescription(methodConfig.getDescription());
        Collection<String> pathParameters = methodConfig.getPathParameters();
        for (ApiParameterConfig parameterConfig : methodConfig.getParameterConfigs()) {
            switch (parameterConfig.getClassification()) {
                case API_PARAMETER: {
                    boolean required;
                    boolean isPathParameter = pathParameters.contains(parameterConfig.getName());
                    PathParameter parameter = isPathParameter ? new PathParameter() : new QueryParameter();
                    parameter.setName(parameterConfig.getName());
                    parameter.setDescription(parameterConfig.getDescription());
                    boolean bl = required = isPathParameter || !parameterConfig.getNullable() && parameterConfig.getDefaultValue() == null;
                    if (parameterConfig.isRepeated()) {
                        TypeToken<?> t = parameterConfig.getRepeatedItemSerializedType();
                        parameter.setType("array");
                        Property p = SwaggerGenerator.getSwaggerArrayProperty(t);
                        if (parameterConfig.isEnum()) {
                            ((StringProperty)p).setEnum(SwaggerGenerator.getEnumValues(t));
                        }
                        parameter.setItems(p);
                    } else if (parameterConfig.isEnum()) {
                        parameter.setType("string");
                        parameter.setEnum(SwaggerGenerator.getEnumValues(parameterConfig.getType()));
                        parameter.setRequired(required);
                    } else {
                        parameter.setType((String)TYPE_TO_STRING_MAP.get((Object)parameterConfig.getSchemaBaseType().getType()));
                        parameter.setFormat((String)TYPE_TO_FORMAT_MAP.get((Object)parameterConfig.getSchemaBaseType().getType()));
                        parameter.setRequired(required);
                    }
                    operation.parameter((Parameter)parameter);
                    break;
                }
                case RESOURCE: {
                    TypeToken<?> requestType = parameterConfig.getSchemaBaseType();
                    Schema schema = genCtx.schemata.getOrAdd(requestType, apiConfig);
                    BodyParameter bodyParameter = new BodyParameter();
                    bodyParameter.setName("body");
                    bodyParameter.setSchema((Model)new RefModel(schema.name()));
                    operation.addParameter((Parameter)bodyParameter);
                    break;
                }
                case UNKNOWN: {
                    throw new IllegalArgumentException("Unclassifiable parameter type found.");
                }
            }
        }
        Response response = new Response().description("A successful response");
        if (methodConfig.hasResourceInResponse()) {
            TypeToken<?> returnType = ApiAnnotationIntrospector.getSchemaType(methodConfig.getReturnType(), apiConfig);
            Schema schema = genCtx.schemata.getOrAdd(returnType, apiConfig);
            response.setSchema((Property)new RefProperty(schema.name()));
        }
        operation.response(200, response);
        this.writeAuthConfig(swagger, methodConfig, operation);
        if (methodConfig.isApiKeyRequired()) {
            List security = operation.getSecurity();
            if (security != null) {
                for (Map securityEntry : security) {
                    securityEntry.put(API_KEY, ImmutableList.of());
                }
            } else {
                operation.addSecurity(API_KEY, (List)ImmutableList.of());
            }
            Map definitions = swagger.getSecurityDefinitions();
            if (definitions == null || !definitions.containsKey(API_KEY)) {
                swagger.securityDefinition(API_KEY, (SecuritySchemeDefinition)new ApiKeyAuthDefinition(API_KEY_PARAM, In.QUERY));
            }
        }
        path.set(methodConfig.getHttpMethod().toLowerCase(), operation);
        this.addDefinedMetricCosts(genCtx.limitMetrics, operation, methodConfig.getMetricCosts());
    }

    private void writeAuthConfig(Swagger swagger, ApiMethodConfig methodConfig, Operation operation) throws ApiConfigException {
        boolean legacyAudiencesIsEmpty;
        ApiIssuerAudienceConfig issuerAudiences = methodConfig.getIssuerAudiences();
        boolean issuerAudiencesIsEmpty = !issuerAudiences.isSpecified() || issuerAudiences.isEmpty();
        List<String> legacyAudiences = methodConfig.getAudiences();
        boolean bl = legacyAudiencesIsEmpty = legacyAudiences == null || legacyAudiences.isEmpty();
        if (issuerAudiencesIsEmpty && legacyAudiencesIsEmpty) {
            return;
        }
        if (!issuerAudiencesIsEmpty) {
            for (String issuer : issuerAudiences.getIssuerNames()) {
                ImmutableSet<String> audiences = issuerAudiences.getAudiences(issuer);
                ApiIssuerConfigs.IssuerConfig issuerConfig = methodConfig.getApiConfig().getIssuers().getIssuer(issuer);
                String fullIssuer = SwaggerGenerator.addNonConflictingSecurityDefinition(swagger, issuerConfig, audiences);
                operation.addSecurity(fullIssuer, (List)ImmutableList.of());
            }
        }
        if (!legacyAudiencesIsEmpty) {
            ImmutableSet legacyAudienceSet = ImmutableSet.copyOf(legacyAudiences);
            String fullIssuer = SwaggerGenerator.addNonConflictingSecurityDefinition(swagger, ApiIssuerConfigs.GOOGLE_ID_TOKEN_ISSUER, (ImmutableSet<String>)legacyAudienceSet);
            String fullAltIssuer = SwaggerGenerator.addNonConflictingSecurityDefinition(swagger, ApiIssuerConfigs.GOOGLE_ID_TOKEN_ISSUER_ALT, (ImmutableSet<String>)legacyAudienceSet);
            operation.addSecurity(fullIssuer, (List)ImmutableList.of());
            operation.addSecurity(fullAltIssuer, (List)ImmutableList.of());
        }
    }

    private void addDefinedMetricCosts(Map<String, ApiLimitMetricConfig> limitMetrics, Operation operation, List<ApiMetricCostConfig> metricCosts) throws ApiConfigException {
        if (!metricCosts.isEmpty()) {
            HashMap<String, Integer> costs = new HashMap<String, Integer>();
            for (ApiMetricCostConfig cost : metricCosts) {
                if (!limitMetrics.containsKey(cost.name())) {
                    throw new ApiConfigException(String.format("Could not add a metric cost for metric '%s'. The limit metric must be defined at the API level.", cost.name()));
                }
                costs.put(cost.name(), cost.cost());
            }
            operation.setVendorExtension("x-google-quota", (Object)ImmutableMap.of((Object)"metricCosts", costs));
        }
    }

    private Model convertToSwaggerSchema(Schema schema) {
        ModelImpl docSchema = new ModelImpl();
        LinkedHashMap fields = Maps.newLinkedHashMap();
        if (!schema.fields().isEmpty()) {
            for (Schema.Field f : schema.fields().values()) {
                fields.put(f.name(), this.convertToSwaggerProperty(f));
            }
            docSchema.setProperties((Map)fields);
        }
        if (!schema.enumValues().isEmpty()) {
            docSchema._enum(schema.enumValues());
        }
        return docSchema;
    }

    private Property convertToSwaggerProperty(Schema.Field f) {
        Property p = (Property)FIELD_TYPE_TO_PROPERTY_MAP.get((Object)f.type());
        if (p != null) {
            return p;
        }
        if (f.type() == FieldType.OBJECT || f.type() == FieldType.ENUM) {
            return new RefProperty(f.schemaReference().get().name());
        }
        if (f.type() == FieldType.ARRAY) {
            return new ArrayProperty(this.convertToSwaggerProperty(f.arrayItemSchema()));
        }
        throw new IllegalArgumentException("could not convert field " + f);
    }

    private static String getOperationId(ApiConfig apiConfig, ApiMethodConfig methodConfig) {
        return (String)CONVERTER.convert((Object)apiConfig.getName()) + (String)CONVERTER.convert((Object)methodConfig.getEndpointMethodName());
    }

    private static Property getSwaggerArrayProperty(TypeToken<?> typeToken) {
        Class type = typeToken.getRawType();
        if (type == String.class) {
            return new StringProperty();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new BooleanProperty();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerProperty();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongProperty();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatProperty();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleProperty();
        }
        if (type == byte[].class) {
            return new ByteArrayProperty();
        }
        if (type.isEnum()) {
            return new StringProperty();
        }
        throw new IllegalArgumentException("invalid property type");
    }

    private Path getOrCreatePath(Swagger swagger, ApiMethodConfig methodConfig) {
        String pathStr = "/" + methodConfig.getCanonicalPath();
        Path path = swagger.getPath(pathStr);
        if (path == null) {
            path = new Path();
            swagger.path(pathStr, path);
        }
        return path;
    }

    private static List<String> getEnumValues(TypeToken<?> t) {
        ArrayList values = Lists.newArrayList();
        for (Object value : t.getRawType().getEnumConstants()) {
            values.add(value.toString());
        }
        return values;
    }

    private static SecuritySchemeDefinition toScheme(ApiIssuerConfigs.IssuerConfig issuerConfig, ImmutableSet<String> audiences) {
        OAuth2Definition tokenDef = new OAuth2Definition().implicit("");
        tokenDef.setVendorExtension("x-google-issuer", (Object)issuerConfig.getIssuer());
        if (!com.google.common.base.Strings.isNullOrEmpty((String)issuerConfig.getJwksUri())) {
            tokenDef.setVendorExtension("x-google-jwks_uri", (Object)issuerConfig.getJwksUri());
        }
        tokenDef.setVendorExtension("x-google-audiences", (Object)COMMA_JOINER.join(audiences));
        return tokenDef;
    }

    private static Map<String, SecuritySchemeDefinition> getOrCreateSecurityDefinitionMap(Swagger swagger) {
        HashMap securityDefinitions = swagger.getSecurityDefinitions();
        if (securityDefinitions == null) {
            securityDefinitions = new HashMap();
            swagger.setSecurityDefinitions(securityDefinitions);
        }
        return securityDefinitions;
    }

    private static String addNonConflictingSecurityDefinition(Swagger swagger, ApiIssuerConfigs.IssuerConfig issuerConfig, ImmutableSet<String> audiences) throws ApiConfigException {
        Map<String, SecuritySchemeDefinition> securityDefinitions = SwaggerGenerator.getOrCreateSecurityDefinitionMap(swagger);
        String issuerPlusHash = String.format("%s-%x", issuerConfig.getName(), audiences.hashCode());
        SecuritySchemeDefinition existingDef = securityDefinitions.get(issuerConfig.getName());
        SecuritySchemeDefinition newDef = SwaggerGenerator.toScheme(issuerConfig, audiences);
        if (existingDef != null && !existingDef.equals(newDef)) {
            throw new ApiConfigException("Multiple conflicting definitions found for issuer " + issuerConfig.getName());
        }
        swagger.securityDefinition(issuerPlusHash, newDef);
        return issuerPlusHash;
    }

    private static class GenerationContext {
        private final Map<String, ApiLimitMetricConfig> limitMetrics = new TreeMap<String, ApiLimitMetricConfig>();
        private ApiConfigValidator validator;
        private boolean writeInternal;
        private SchemaRepository schemata;

        private GenerationContext() {
        }
    }

    public static class SwaggerContext {
        private Scheme scheme = Scheme.HTTPS;
        private String hostname = "myapi.appspot.com";
        private String basePath = "/_ah/api";
        private String docVersion = "1.0.0";

        public SwaggerContext setApiRoot(String apiRoot) {
            try {
                URL url = new URL(apiRoot);
                this.hostname = url.getHost();
                if ("http".equals(url.getProtocol()) && url.getPort() != 80 && url.getPort() != -1 || "https".equals(url.getProtocol()) && url.getPort() != 443 && url.getPort() != -1) {
                    this.hostname = this.hostname + ":" + url.getPort();
                }
                this.basePath = Strings.stripTrailingSlash(url.getPath());
                this.setScheme(url.getProtocol());
                return this;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public SwaggerContext setScheme(String scheme) {
            this.scheme = "http".equals(scheme) ? Scheme.HTTP : Scheme.HTTPS;
            return this;
        }

        public SwaggerContext setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public SwaggerContext setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public SwaggerContext setDocVersion(String docVersion) {
            this.docVersion = docVersion;
            return this;
        }
    }
}

