/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.dispatcher;

import com.google.api.server.spi.dispatcher.DispatcherContext;
import com.google.api.server.spi.dispatcher.DispatcherHandler;
import com.google.api.server.spi.dispatcher.HttpMethod;
import com.google.api.server.spi.dispatcher.PathTrie;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class PathDispatcher<ContextT extends DispatcherContext> {
    private final PathTrie<DispatcherHandler<ContextT>> trie;

    private PathDispatcher(Builder<ContextT> builder) {
        this.trie = ((Builder)builder).trieBuilder.build();
    }

    public boolean dispatch(String httpMethod, String path, ContextT context) throws IOException {
        PathTrie.Result<DispatcherHandler<ContextT>> result;
        Preconditions.checkNotNull((Object)httpMethod, (Object)"httpMethod");
        Preconditions.checkNotNull((Object)path, (Object)"path");
        HttpMethod method = HttpMethod.fromString(httpMethod);
        if (method != null && (result = this.trie.resolve(method, path)) != null) {
            ((DispatcherContext)context).setRawPathParameters(result.getRawParameters());
            result.getResult().handle(context);
            return true;
        }
        return false;
    }

    public static <T extends DispatcherContext> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends DispatcherContext> {
        private final PathTrie.Builder<DispatcherHandler<T>> trieBuilder = PathTrie.builder(false);

        public Builder<T> add(String httpMethod, String pathTemplate, DispatcherHandler<T> handler) {
            Preconditions.checkNotNull((Object)httpMethod, (Object)"httpMethod");
            Preconditions.checkNotNull((Object)pathTemplate, (Object)"pathTemplate");
            Preconditions.checkNotNull(handler, (Object)"handler");
            this.trieBuilder.add(HttpMethod.valueOf(httpMethod.toUpperCase()), pathTemplate, handler);
            return this;
        }

        public PathDispatcher<T> build() {
            return new PathDispatcher(this);
        }
    }
}

