/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.Strings;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.request.ServletRequestParamReader;
import com.google.api.server.spi.response.BadRequestException;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class RestServletRequestParamReader
extends ServletRequestParamReader {
    private static final Logger logger = Logger.getLogger(RestServletRequestParamReader.class.getName());
    private static final Splitter COMPOSITE_PATH_SPLITTER = Splitter.on((char)',');
    private final Map<String, String> rawPathParameters;
    private final Map<String, ApiParameterConfig> parameterConfigMap;

    public RestServletRequestParamReader(EndpointMethod method, HttpServletRequest servletRequest, ServletContext servletContext, ApiSerializationConfig serializationConfig, ApiMethodConfig methodConfig, Map<String, String> rawPathParameters) {
        super(method, servletRequest, servletContext, serializationConfig, methodConfig);
        this.rawPathParameters = rawPathParameters;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ApiParameterConfig config : methodConfig.getParameterConfigs()) {
            if (config.getName() == null) continue;
            builder.put((Object)config.getName(), (Object)config);
        }
        this.parameterConfigMap = builder.build();
    }

    @Override
    public Object[] read() throws ServiceException {
        try {
            ArrayNode values;
            JsonNode node;
            EndpointMethod method = this.getMethod();
            if (method.getParameterClasses().length == 0) {
                return new Object[0];
            }
            String requestBody = IoUtil.readRequestBody(this.servletRequest);
            logger.log(Level.FINE, "requestBody=" + requestBody);
            JsonNode jsonNode = node = Strings.isEmptyOrWhitespace(requestBody) ? this.objectReader.createObjectNode() : this.objectReader.readTree(requestBody);
            if (!node.isObject()) {
                throw new BadRequestException("expected a JSON object body");
            }
            ObjectNode body = (ObjectNode)node;
            ImmutableMap<String, Class<?>> parameterMap = RestServletRequestParamReader.getParameterMap(method);
            Enumeration e = this.servletRequest.getParameterNames();
            while (e.hasMoreElements()) {
                String string = (String)e.nextElement();
                if (body.has(string)) continue;
                Class parameterClass = (Class)parameterMap.get(string);
                ApiParameterConfig parameterConfig = this.parameterConfigMap.get(string);
                if (parameterClass != null && parameterConfig.isRepeated()) {
                    values = body.putArray(string);
                    for (String value : this.servletRequest.getParameterValues(string)) {
                        values.add(value);
                    }
                    continue;
                }
                body.put(string, this.servletRequest.getParameterValues(string)[0]);
            }
            for (Map.Entry<String, String> entry : this.rawPathParameters.entrySet()) {
                String parameterName = entry.getKey();
                Class parameterClass = (Class)parameterMap.get(parameterName);
                if (parameterClass == null || body.has(parameterName)) continue;
                if (this.parameterConfigMap.get(parameterName).isRepeated()) {
                    values = body.putArray(parameterName);
                    for (String value : COMPOSITE_PATH_SPLITTER.split((CharSequence)entry.getValue())) {
                        values.add(value);
                    }
                    continue;
                }
                body.put(parameterName, entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.parameterConfigMap.entrySet()) {
                if (body.has(entry.getKey()) || ((ApiParameterConfig)entry.getValue()).getDefaultValue() == null) continue;
                body.put(entry.getKey(), ((ApiParameterConfig)entry.getValue()).getDefaultValue());
            }
            return this.deserializeParams((JsonNode)body);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new BadRequestException(e);
        }
    }

    private static ImmutableMap<String, Class<?>> getParameterMap(EndpointMethod method) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List<String> parameterNames = RestServletRequestParamReader.getParameterNames(method);
        for (int i = 0; i < parameterNames.size(); ++i) {
            String parameterName = parameterNames.get(i);
            if (parameterName == null) continue;
            builder.put((Object)parameterName, method.getParameterClasses()[i]);
        }
        return builder.build();
    }
}

