/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.response.ErrorMap;
import com.google.api.server.spi.response.ServletResponseResultWriter;
import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class RestResponseResultWriter
extends ServletResponseResultWriter {
    private final boolean enableExceptionCompatibility;
    private final ObjectMapper objectMapper;

    public RestResponseResultWriter(HttpServletResponse servletResponse, ApiSerializationConfig serializationConfig, boolean prettyPrint, boolean enableExceptionCompatibility) {
        super(servletResponse, serializationConfig, prettyPrint);
        this.enableExceptionCompatibility = enableExceptionCompatibility;
        this.objectMapper = ObjectMapperUtil.createStandardObjectMapper(serializationConfig);
    }

    @Override
    public void writeError(ServiceException e) throws IOException {
        ErrorMap errorMap = new ErrorMap(this.enableExceptionCompatibility);
        int code = errorMap.getHttpStatus(e.getStatusCode());
        String reason = !Strings.isNullOrEmpty((String)e.getReason()) ? e.getReason() : errorMap.getReason(e.getStatusCode());
        String domain = !Strings.isNullOrEmpty((String)e.getDomain()) ? e.getDomain() : errorMap.getDomain(e.getStatusCode());
        this.write(code, e.getHeaders(), this.writeValueAsString(this.createError(code, reason, domain, e.getMessage())));
    }

    private Object createError(int code, String reason, String domain, String message) {
        ObjectNode topLevel = this.objectMapper.createObjectNode();
        ObjectNode topError = this.objectMapper.createObjectNode();
        ObjectNode error = this.objectMapper.createObjectNode();
        error.put("domain", domain);
        error.put("reason", reason);
        error.put("message", message);
        topError.set("errors", (JsonNode)this.objectMapper.createArrayNode().add((JsonNode)error));
        topError.put("code", code);
        topError.put("message", message);
        topLevel.set("error", (JsonNode)topError);
        return topLevel;
    }
}

