/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.server.spi.Client;
import com.google.api.server.spi.auth.GoogleAuth;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.request.Attribute;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class GoogleJwtAuthenticator
implements Authenticator {
    private static final Logger logger = Logger.getLogger(GoogleJwtAuthenticator.class.getName());
    private final GoogleIdTokenVerifier verifier;

    public GoogleJwtAuthenticator() {
        this(new GoogleIdTokenVerifier.Builder(Client.getInstance().getHttpTransport(), Client.getInstance().getJsonFactory()).build());
    }

    public GoogleJwtAuthenticator(GoogleIdTokenVerifier verifier) {
        this.verifier = verifier;
    }

    @VisibleForTesting
    GoogleIdToken verifyToken(String token) {
        if (token == null) {
            return null;
        }
        try {
            return this.verifier.verify(token);
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            logger.warning(e.getMessage());
            return null;
        }
    }

    @Override
    public User authenticate(HttpServletRequest request) {
        User user;
        Attribute attr = Attribute.from(request);
        if (attr.isEnabled("endpoints:Skip-Token-Auth")) {
            return null;
        }
        String token = GoogleAuth.getAuthToken(request);
        if (!GoogleAuth.isJwt(token)) {
            return null;
        }
        GoogleIdToken idToken = this.verifyToken(token);
        if (idToken == null) {
            return null;
        }
        String clientId = idToken.getPayload().getAuthorizedParty();
        String audience = (String)idToken.getPayload().getAudience();
        ApiMethodConfig config = (ApiMethodConfig)attr.get("endpoints:Api-Method-Config");
        if (attr.isEnabled("endpoints:Enable-Client-Id-Whitelist") && !GoogleAuth.checkClientId(clientId, config.getClientIds(), false)) {
            logger.warning("ClientId is not allowed: " + clientId);
            return null;
        }
        if (!GoogleAuth.checkAudience(audience, config.getAudiences(), clientId)) {
            logger.warning("Audience is not allowed: " + audience);
            return null;
        }
        String userId = idToken.getPayload().getSubject();
        String email = idToken.getPayload().getEmail();
        User user2 = user = userId == null && email == null ? null : new User(userId, email);
        if (attr.isEnabled("endpoints:Require-AppEngine-User")) {
            com.google.appengine.api.users.User appEngineUser = email == null ? null : new com.google.appengine.api.users.User(email, "");
            attr.set("endpoints:Authenticated-AppEngine-User", appEngineUser);
            logger.log(Level.FINE, "appEngineUser = {0}", appEngineUser);
        } else {
            logger.log(Level.FINE, "user = {0}", user);
        }
        return user;
    }
}

