/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.Strings;
import com.google.api.server.spi.auth.GoogleAuth;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.request.Attribute;
import com.google.api.server.spi.response.ServiceUnavailableException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class GoogleOAuth2Authenticator
implements Authenticator {
    private static final Logger logger = Logger.getLogger(GoogleOAuth2Authenticator.class.getName());

    @Override
    public User authenticate(HttpServletRequest request) throws ServiceUnavailableException {
        Attribute attr = Attribute.from(request);
        if (attr.isEnabled("endpoints:Skip-Token-Auth")) {
            return null;
        }
        String token = GoogleAuth.getAuthToken(request);
        if (!GoogleAuth.isOAuth2Token(token)) {
            return null;
        }
        GoogleAuth.TokenInfo tokenInfo = this.getTokenInfoRemote(token);
        if (tokenInfo == null) {
            return null;
        }
        ApiMethodConfig config = (ApiMethodConfig)request.getAttribute("endpoints:Api-Method-Config");
        if (Strings.isEmptyOrWhitespace(tokenInfo.scopes)) {
            logger.warning("Access token does not contain a valid scope");
            return null;
        }
        Object[] authorizedScopes = tokenInfo.scopes.split("\\s+");
        if (!config.getScopeExpression().isAuthorized((Set<String>)ImmutableSet.copyOf((Object[])authorizedScopes))) {
            logger.warning("Access token does not contain sufficient scopes from: " + config.getScopeExpression());
            return null;
        }
        if (attr.isEnabled("endpoints:Enable-Client-Id-Whitelist") && !GoogleAuth.checkClientId(tokenInfo.clientId, config.getClientIds(), true)) {
            logger.warning("ClientId is not allowed: " + tokenInfo.clientId);
            return null;
        }
        User user = new User(tokenInfo.userId, tokenInfo.email);
        if (attr.isEnabled("endpoints:Require-AppEngine-User")) {
            com.google.appengine.api.users.User appEngineUser = new com.google.appengine.api.users.User(tokenInfo.email, "");
            request.setAttribute("endpoints:Authenticated-AppEngine-User", (Object)appEngineUser);
        }
        return user;
    }

    @VisibleForTesting
    GoogleAuth.TokenInfo getTokenInfoRemote(String token) throws ServiceUnavailableException {
        return GoogleAuth.getTokenInfoRemote(token);
    }
}

