/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.validation;

import com.google.api.client.util.Strings;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfigInconsistency;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiIssuerConfigs;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiNamespaceConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.Schema;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.api.server.spi.config.model.Serializers;
import com.google.api.server.spi.config.model.Types;
import com.google.api.server.spi.config.validation.ApiClassConfigInvalidException;
import com.google.api.server.spi.config.validation.ApiConfigInvalidException;
import com.google.api.server.spi.config.validation.ApiMethodConfigInvalidException;
import com.google.api.server.spi.config.validation.ApiParameterConfigInvalidException;
import com.google.api.server.spi.config.validation.CollectionResourceException;
import com.google.api.server.spi.config.validation.DuplicateParameterNameException;
import com.google.api.server.spi.config.validation.DuplicateRestPathException;
import com.google.api.server.spi.config.validation.GenericTypeException;
import com.google.api.server.spi.config.validation.InconsistentApiConfigurationException;
import com.google.api.server.spi.config.validation.InvalidApiNameException;
import com.google.api.server.spi.config.validation.InvalidConstructorException;
import com.google.api.server.spi.config.validation.InvalidIssuerValueException;
import com.google.api.server.spi.config.validation.InvalidMethodNameException;
import com.google.api.server.spi.config.validation.InvalidNamespaceException;
import com.google.api.server.spi.config.validation.InvalidParameterAnnotationsException;
import com.google.api.server.spi.config.validation.InvalidReturnTypeException;
import com.google.api.server.spi.config.validation.MissingParameterNameException;
import com.google.api.server.spi.config.validation.MultipleTransformersException;
import com.google.api.server.spi.config.validation.NamedResourceException;
import com.google.api.server.spi.config.validation.NestedCollectionException;
import com.google.api.server.spi.config.validation.NoTransformerInterfaceException;
import com.google.api.server.spi.config.validation.OverloadedMethodException;
import com.google.api.server.spi.config.validation.PropertyParameterNameConflictException;
import com.google.api.server.spi.config.validation.WrongTransformerTypeException;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ApiConfigValidator {
    private static final Logger log = Logger.getLogger(ApiConfigValidator.class.getName());
    private static final Pattern API_NAME_PATTERN = Pattern.compile("^[a-z]+[A-Za-z0-9]*$");
    private static final Pattern API_METHOD_NAME_PATTERN = Pattern.compile("^\\w+(\\.\\w+)*$");
    private final TypeLoader typeLoader;
    private final SchemaRepository schemaRepository;

    public ApiConfigValidator(TypeLoader typeLoader, SchemaRepository schemaRepository) {
        this.typeLoader = typeLoader;
        this.schemaRepository = schemaRepository;
    }

    public void validate(Iterable<? extends ApiConfig> apiConfigs) throws ApiConfigInvalidException, ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        if (Iterables.isEmpty(apiConfigs)) {
            return;
        }
        HashMap restfulSignatures = Maps.newHashMap();
        Iterator<? extends ApiConfig> i = apiConfigs.iterator();
        ApiConfig first = i.next();
        this.validate(first, restfulSignatures);
        while (i.hasNext()) {
            ApiConfig config = i.next();
            Iterable<ApiConfigInconsistency<Object>> inconsistencies = config.getConfigurationInconsistencies(first);
            if (!Iterables.isEmpty(inconsistencies)) {
                throw new InconsistentApiConfigurationException(config, first, inconsistencies);
            }
            this.validate(config, restfulSignatures);
        }
    }

    public void validate(ApiConfig config) throws ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException, ApiConfigInvalidException {
        this.validate(config, new HashMap<String, ApiMethodConfig>());
    }

    private void validate(ApiConfig config, Map<String, ApiMethodConfig> restfulSignatures) throws ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException, ApiConfigInvalidException {
        this.validateApiConfig(config);
        this.validateThirdPartyAuth(config.getApiClassConfig());
        this.validateMethods(config.getApiClassConfig().getMethods(), restfulSignatures);
    }

    private void validateApiConfig(ApiConfig config) throws InvalidNamespaceException, InvalidApiNameException, InvalidIssuerValueException.ForApi {
        this.validateApiName(config);
        this.validateNamespaceConfig(config.getNamespaceConfig(), config.getApiClassConfig());
        this.validateThirdPartyAuth(config);
    }

    private void validateApiName(ApiConfig config) throws InvalidApiNameException {
        if (!API_NAME_PATTERN.matcher(config.getName()).matches()) {
            throw new InvalidApiNameException(config, config.getName());
        }
    }

    private void validateNamespaceConfig(ApiNamespaceConfig config, ApiClassConfig apiConfig) throws InvalidNamespaceException {
        boolean ownerFullySpecified;
        boolean allUnspecified = config.getOwnerDomain().isEmpty() && config.getOwnerName().isEmpty() && config.getPackagePath().isEmpty();
        boolean bl = ownerFullySpecified = !config.getOwnerDomain().isEmpty() && !config.getOwnerName().isEmpty();
        if (!allUnspecified && !ownerFullySpecified) {
            throw new InvalidNamespaceException(apiConfig);
        }
    }

    private void validateThirdPartyAuth(ApiConfig config) throws InvalidIssuerValueException.ForApi {
        String error = ApiConfigValidator.checkIssuers(config.getIssuers());
        if (error != null) {
            throw new InvalidIssuerValueException.ForApi(config, error);
        }
        error = ApiConfigValidator.checkIssuerAudiences(config.getIssuers(), config.getIssuerAudiences());
        if (error != null) {
            throw new InvalidIssuerValueException.ForApi(config, error);
        }
    }

    private void validateThirdPartyAuth(ApiClassConfig config) throws InvalidIssuerValueException.ForApiClass {
        String error = ApiConfigValidator.checkIssuerAudiences(config.getApiConfig().getIssuers(), config.getIssuerAudiences());
        if (error != null) {
            throw new InvalidIssuerValueException.ForApiClass(config, error);
        }
    }

    private void validateMethods(ApiClassConfig.MethodConfigMap configMap, Map<String, ApiMethodConfig> restfulSignatures) throws ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        HashMap javaMethodNames = Maps.newHashMap();
        for (ApiMethodConfig methodConfig : configMap.values()) {
            if (methodConfig.isIgnored()) continue;
            this.validateRestSignatureUnique(methodConfig, restfulSignatures);
            this.validateBackendMethodNameUnique(methodConfig, javaMethodNames);
            this.validateMethod(methodConfig);
            this.validateResourceAndFieldNames(methodConfig);
        }
    }

    private void validateRestSignatureUnique(ApiMethodConfig methodConfig, Map<String, ApiMethodConfig> restfulSignatures) throws DuplicateRestPathException {
        String restSignature = methodConfig.getRestfulSignature();
        ApiMethodConfig seenMethod = restfulSignatures.get(restSignature);
        if (seenMethod != null) {
            throw new DuplicateRestPathException(methodConfig.getApiClassConfig(), restSignature, methodConfig.getName(), seenMethod.getName());
        }
        restfulSignatures.put(restSignature, methodConfig);
    }

    private void validateBackendMethodNameUnique(ApiMethodConfig methodConfig, Map<String, ApiMethodConfig> javaMethodNames) throws OverloadedMethodException {
        String javaName = methodConfig.getFullJavaName();
        ApiMethodConfig seenMethod = javaMethodNames.get(javaName);
        if (seenMethod != null) {
            throw new OverloadedMethodException(methodConfig.getApiClassConfig(), javaName, methodConfig.getName(), seenMethod.getName());
        }
        javaMethodNames.put(javaName, methodConfig);
    }

    private void validateResourceAndFieldNames(ApiMethodConfig methodConfig) throws PropertyParameterNameConflictException {
        for (ApiParameterConfig parameterConfig : methodConfig.getParameterConfigs()) {
            if (parameterConfig.getClassification() != ApiParameterConfig.Classification.RESOURCE) continue;
            Schema schema = this.schemaRepository.getOrAdd(parameterConfig.getSchemaBaseType(), methodConfig.getApiConfig());
            ImmutableSortedSet fieldNames = schema.fields().keySet();
            for (ApiParameterConfig parameter : methodConfig.getParameterConfigs()) {
                if (parameter.getClassification() != ApiParameterConfig.Classification.API_PARAMETER || "id".equals(parameter.getName()) || !fieldNames.contains(parameter.getName())) continue;
                log.warning("Parameter " + parameter.getName() + " conflicts with a resource field name. This may result in unexpected values in the request.");
            }
        }
    }

    private void validateMethod(ApiMethodConfig config) throws ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        if (!API_METHOD_NAME_PATTERN.matcher(config.getName()).matches()) {
            throw new InvalidMethodNameException(config, config.getName());
        }
        this.validateNullaryConstructor(config.getAuthenticators(), config, "custom authenticator");
        this.validateNullaryConstructor(config.getPeerAuthenticators(), config, "custom peer authenticator");
        HashSet parameterNames = Sets.newHashSet();
        for (ApiParameterConfig parameter : config.getParameterConfigs()) {
            this.validateParameter(parameter, parameterNames, config.getPathParameters());
        }
        this.validateThirdPartyAuth(config);
        TypeToken<?> returnType = config.getReturnType();
        if (this.typeLoader.isSchemaType(returnType) || Types.isEnumType(returnType)) {
            throw new InvalidReturnTypeException(config, returnType);
        }
    }

    private void validateThirdPartyAuth(ApiMethodConfig config) throws InvalidIssuerValueException.ForApiMethod {
        String error = ApiConfigValidator.checkIssuerAudiences(config.getApiClassConfig().getApiConfig().getIssuers(), config.getIssuerAudiences());
        if (error != null) {
            throw new InvalidIssuerValueException.ForApiMethod(config, error);
        }
    }

    private void validateNullaryConstructor(List<?> classes, ApiMethodConfig config, String description) throws ApiMethodConfigInvalidException {
        if (classes == null) {
            return;
        }
        for (Object clazz : classes) {
            assert (clazz instanceof Class);
            boolean nullaryFound = false;
            for (Constructor<?> constructor : ((Class)clazz).getConstructors()) {
                if (!ApiConfigValidator.isConstructorPublicNullary(constructor)) continue;
                nullaryFound = true;
                break;
            }
            if (nullaryFound) continue;
            throw new InvalidConstructorException((Class)clazz, config, description);
        }
    }

    private static boolean isConstructorPublicNullary(Constructor<?> constructor) {
        return constructor.getParameterTypes().length == 0 && (constructor.getModifiers() & 1) != 0;
    }

    private void validateParameter(ApiParameterConfig parameter, Set<String> parameterNames, Collection<String> pathParameters) throws ApiParameterConfigInvalidException {
        TypeToken<?> type;
        try {
            this.validateParameterSerializers(parameter, parameter.getSerializers(), parameter.getType());
            this.validateParameterSerializers(parameter, parameter.getRepeatedItemSerializers(), parameter.getRepeatedItemType());
        }
        catch (IllegalStateException e) {
            throw new ApiParameterConfigInvalidException(parameter, e.getMessage());
        }
        if (parameter.isRepeated()) {
            type = parameter.getRepeatedItemSerializedType();
            if (Types.isArrayType(type)) {
                throw new NestedCollectionException(parameter, type);
            }
        } else {
            type = parameter.getSchemaBaseType();
        }
        switch (parameter.getClassification()) {
            case INJECTED: {
                break;
            }
            case API_PARAMETER: {
                this.validateApiParameter(parameter, parameterNames, pathParameters, type);
                break;
            }
            case RESOURCE: {
                this.validateResourceParameter(parameter, type);
                break;
            }
            case UNKNOWN: {
                throw new GenericTypeException(parameter);
            }
            default: {
                throw new AssertionError((Object)("Unrecognized parameter classification: " + (Object)((Object)parameter.getClassification())));
            }
        }
    }

    private void validateParameterSerializers(ApiParameterConfig config, List<Class<? extends Transformer<?, ?>>> serializers, TypeToken<?> parameterType) throws ApiParameterConfigInvalidException {
        if (serializers.isEmpty()) {
            return;
        }
        if (serializers.size() > 1) {
            throw new MultipleTransformersException(config, serializers);
        }
        TypeToken<?> sourceType = Serializers.getSourceType(serializers.get(0));
        TypeToken<?> serializedType = Serializers.getTargetType(serializers.get(0));
        if (sourceType == null || serializedType == null) {
            throw new NoTransformerInterfaceException(config, serializers.get(0));
        }
        if (!sourceType.isSupertypeOf(parameterType)) {
            throw new WrongTransformerTypeException(config, serializers.get(0), parameterType, sourceType);
        }
    }

    private void validateApiParameter(ApiParameterConfig parameter, Set<String> parameterNames, Collection<String> pathParameters, TypeToken<?> type) throws ApiParameterConfigInvalidException {
        if (parameter.getName() == null) {
            throw new MissingParameterNameException(parameter, type);
        }
        if (!parameterNames.add(parameter.getName())) {
            throw new DuplicateParameterNameException(parameter);
        }
        if ((parameter.getNullable() || parameter.getDefaultValue() != null) && pathParameters.contains(parameter.getName())) {
            throw new InvalidParameterAnnotationsException(parameter);
        }
    }

    private void validateResourceParameter(ApiParameterConfig parameter, TypeToken<?> type) throws ApiParameterConfigInvalidException {
        if (parameter.isRepeated()) {
            throw new CollectionResourceException(parameter, parameter.getRepeatedItemSerializedType(), parameter.getSchemaBaseType());
        }
        if (parameter.getName() != null) {
            throw new NamedResourceException(parameter, type);
        }
    }

    private static String checkIssuers(ApiIssuerConfigs issuers) {
        if (!issuers.isSpecified()) {
            return null;
        }
        for (ApiIssuerConfigs.IssuerConfig issuer : issuers.asMap().values()) {
            if (Strings.isNullOrEmpty((String)issuer.getName())) {
                return "issuer name cannot be blank";
            }
            if (!Strings.isNullOrEmpty((String)issuer.getIssuer())) continue;
            return "issuer '" + issuer.getName() + "' cannot have a blank issuer value";
        }
        return null;
    }

    private static String checkIssuerAudiences(ApiIssuerConfigs issuerConfigs, ApiIssuerAudienceConfig issuerAudiences) {
        if (!issuerAudiences.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : issuerAudiences.asMap().entrySet()) {
            if (!issuerConfigs.hasIssuer((String)entry.getKey())) {
                return "cannot specify audiences for unknown issuer '" + (String)entry.getKey() + "'";
            }
            for (String audience : (Collection)entry.getValue()) {
                if (!Strings.isNullOrEmpty((String)audience)) continue;
                return "issuer '" + (String)entry.getKey() + "' cannot have null or blank audiences";
            }
        }
        return null;
    }
}

