/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.types;

import com.google.api.client.util.DateTime;
import com.google.common.base.Preconditions;

public final class DateAndTime {
    private final String rfc3339String;
    private final DateTime clientDateTime;

    private DateAndTime(String rfc3339String) {
        this.rfc3339String = (String)Preconditions.checkNotNull((Object)rfc3339String);
        this.clientDateTime = DateTime.parseRfc3339((String)rfc3339String);
    }

    public String toRfc3339String() {
        return this.rfc3339String;
    }

    public static DateAndTime parseRfc3339String(String rfc3339String) {
        try {
            return new DateAndTime(rfc3339String);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("DateAndTime string is not valid RFC3339: " + rfc3339String, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateAndTime)) {
            return false;
        }
        DateAndTime other = (DateAndTime)obj;
        return this.clientDateTime.equals((Object)other.clientDateTime);
    }

    public int hashCode() {
        return this.clientDateTime.hashCode();
    }

    public String toString() {
        return this.toRfc3339String();
    }
}

