/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.discovery.DiscoveryProvider;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachingDiscoveryProvider
implements DiscoveryProvider {
    private static final Logger logger = Logger.getLogger(CachingDiscoveryProvider.class.getName());
    private static final int CACHE_EXPIRY_MINS = 10;
    private final Cache<ApiKey, RestDescription> restDocuments;
    private final Cache<ApiKey, RpcDescription> rpcDocuments;
    private final Cache<String, DirectoryList> directoryByRoot;
    private final DiscoveryProvider delegate;

    public CachingDiscoveryProvider(DiscoveryProvider delegate) {
        this(delegate, 10L, TimeUnit.MINUTES);
    }

    public CachingDiscoveryProvider(DiscoveryProvider delegate, long cacheExpiry, TimeUnit cacheExpiryUnit) {
        this.delegate = delegate;
        this.restDocuments = CacheBuilder.newBuilder().expireAfterAccess(cacheExpiry, cacheExpiryUnit).build();
        this.rpcDocuments = CacheBuilder.newBuilder().expireAfterAccess(cacheExpiry, cacheExpiryUnit).build();
        this.directoryByRoot = CacheBuilder.newBuilder().expireAfterAccess(cacheExpiry, cacheExpiryUnit).build();
    }

    @Override
    public RestDescription getRestDocument(final String root, final String name, final String version) throws NotFoundException, InternalServerErrorException {
        return this.getDiscoveryDoc(this.restDocuments, root, name, version, new Callable<RestDescription>(){

            @Override
            public RestDescription call() throws NotFoundException, InternalServerErrorException {
                return CachingDiscoveryProvider.this.delegate.getRestDocument(root, name, version);
            }
        });
    }

    @Override
    public RpcDescription getRpcDocument(final String root, final String name, final String version) throws NotFoundException, InternalServerErrorException {
        return this.getDiscoveryDoc(this.rpcDocuments, root, name, version, new Callable<RpcDescription>(){

            @Override
            public RpcDescription call() throws NotFoundException, InternalServerErrorException {
                return CachingDiscoveryProvider.this.delegate.getRpcDocument(root, name, version);
            }
        });
    }

    @Override
    public DirectoryList getDirectory(final String root) throws InternalServerErrorException {
        try {
            return (DirectoryList)((Object)this.directoryByRoot.get((Object)root, (Callable)new Callable<DirectoryList>(){

                @Override
                public DirectoryList call() throws Exception {
                    return CachingDiscoveryProvider.this.delegate.getDirectory(root);
                }
            }));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof InternalServerErrorException) {
                throw (InternalServerErrorException)e.getCause();
            }
            logger.log(Level.SEVERE, "Could not generate or cache directory", e.getCause());
            throw new InternalServerErrorException("Internal Server Error", e.getCause());
        }
    }

    @VisibleForTesting
    void cleanUp() {
        this.restDocuments.cleanUp();
        this.rpcDocuments.cleanUp();
        this.directoryByRoot.cleanUp();
    }

    private <T> T getDiscoveryDoc(Cache<ApiKey, T> cache, String root, String name, String version, Callable<T> loader) throws NotFoundException, InternalServerErrorException {
        ApiKey key = new ApiKey(name, version, root);
        try {
            return (T)cache.get((Object)key, loader);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof NotFoundException) {
                throw (NotFoundException)e.getCause();
            }
            if (e.getCause() instanceof InternalServerErrorException) {
                throw (InternalServerErrorException)e.getCause();
            }
            logger.log(Level.SEVERE, "Could not generate or cache discovery doc", e.getCause());
            throw new InternalServerErrorException("Internal Server Error", e.getCause());
        }
    }
}

