/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.handlers;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.EndpointsContext;
import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.StandardParameters;
import com.google.api.server.spi.dispatcher.DispatcherHandler;
import com.google.api.server.spi.handlers.CorsHandler;
import com.google.api.server.spi.request.Attribute;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.request.RestServletRequestParamReader;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.RestResponseResultWriter;
import com.google.api.server.spi.response.ResultWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EndpointsMethodHandler {
    private static final Logger logger = Logger.getLogger(EndpointsMethodHandler.class.getName());
    private final ServletInitializationParameters initParameters;
    private final ServletContext servletContext;
    private final EndpointMethod endpointMethod;
    private final ApiMethodConfig methodConfig;
    private final SystemService systemService;
    private final RestHandler restHandler;
    private final String restPath;

    public EndpointsMethodHandler(ServletInitializationParameters initParameters, ServletContext servletContext, EndpointMethod endpointMethod, ApiConfig apiConfig, ApiMethodConfig methodConfig, SystemService systemService) {
        this.initParameters = initParameters;
        this.servletContext = servletContext;
        this.endpointMethod = endpointMethod;
        this.methodConfig = methodConfig;
        this.systemService = systemService;
        this.restHandler = new RestHandler();
        this.restPath = EndpointsMethodHandler.createRestPath(apiConfig, methodConfig);
    }

    public String getRestMethod() {
        return this.methodConfig.getHttpMethod();
    }

    public String getRestPath() {
        return this.restPath;
    }

    public DispatcherHandler<EndpointsContext> getRestHandler() {
        return this.restHandler;
    }

    @VisibleForTesting
    protected ParamReader createRestParamReader(EndpointsContext context, ApiSerializationConfig serializationConfig) {
        return new RestServletRequestParamReader(this.endpointMethod, context.getRequest(), this.servletContext, serializationConfig, this.methodConfig, (Map<String, String>)context.getRawPathParameters());
    }

    @VisibleForTesting
    protected ResultWriter createResultWriter(EndpointsContext context, ApiSerializationConfig serializationConfig) {
        return new RestResponseResultWriter(context.getResponse(), serializationConfig, StandardParameters.shouldPrettyPrint(context.getRequest()), this.initParameters.isExceptionCompatibilityEnabled());
    }

    private ResultWriter createErrorResultWriter(EndpointsContext context) {
        return this.createResultWriter(context, null);
    }

    private static String createRestPath(ApiConfig apiConfig, ApiMethodConfig methodConfig) {
        if (methodConfig.getPath().startsWith("/")) {
            return methodConfig.getPath().substring(1);
        }
        return String.format("%s/%s/%s", apiConfig.getName(), apiConfig.getVersion(), methodConfig.getPath());
    }

    private class RestHandler
    implements DispatcherHandler<EndpointsContext> {
        private RestHandler() {
        }

        @Override
        public void handle(EndpointsContext context) throws IOException {
            try {
                HttpServletRequest request = context.getRequest();
                Attribute.bindStandardRequestAttributes(request, EndpointsMethodHandler.this.methodConfig, EndpointsMethodHandler.this.initParameters);
                String serviceName = EndpointsMethodHandler.this.endpointMethod.getEndpointClass().getName();
                Object service = EndpointsMethodHandler.this.systemService.findService(serviceName);
                ApiSerializationConfig serializationConfig = EndpointsMethodHandler.this.systemService.getSerializationConfig(serviceName);
                ParamReader reader = EndpointsMethodHandler.this.createRestParamReader(context, serializationConfig);
                ResultWriter writer = EndpointsMethodHandler.this.createResultWriter(context, serializationConfig);
                EndpointsMethodHandler.this.systemService.invokeServiceMethod(service, EndpointsMethodHandler.this.endpointMethod.getMethod(), reader, writer);
                if (request.getHeader("Origin") != null) {
                    HttpServletResponse response = context.getResponse();
                    CorsHandler.allowOrigin(request, response);
                    CorsHandler.setAccessControlAllowCredentials(response);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "exception occurred while invoking backend method", e);
                EndpointsMethodHandler.this.createErrorResultWriter(context).writeError(new InternalServerErrorException("backend error"));
            }
        }
    }
}

