/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.Strings;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiKey;
import com.google.api.server.spi.config.model.SchemaRepository;
import com.google.api.server.spi.discovery.AbstractDiscoveryProvider;
import com.google.api.server.spi.discovery.DiscoveryGenerator;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class LocalDiscoveryProvider
extends AbstractDiscoveryProvider {
    private static final String PLACEHOLDER_ROOT = "https://placeholder.appspot.com/_ah/api";
    private final DiscoveryGenerator generator;
    private final SchemaRepository repository;
    private Map<ApiKey, RestDescription> discoveryDocs;
    private DirectoryList directoryList;

    public LocalDiscoveryProvider(ImmutableList<ApiConfig> apiConfigs, DiscoveryGenerator generator, SchemaRepository repository) {
        super(apiConfigs);
        this.generator = generator;
        this.repository = repository;
    }

    @Override
    public RestDescription getRestDocument(String root, String name, String version) throws NotFoundException {
        this.ensureDiscoveryResult();
        RestDescription doc = this.discoveryDocs.get(new ApiKey(name, version, null));
        if (doc == null) {
            throw new NotFoundException("Not Found");
        }
        return LocalDiscoveryProvider.replaceRoot(doc, root);
    }

    @Override
    public RpcDescription getRpcDocument(String root, String name, String version) throws NotFoundException {
        throw new NotFoundException("RPC discovery is no longer supported.");
    }

    @Override
    public DirectoryList getDirectory(String root) {
        this.ensureDiscoveryResult();
        return LocalDiscoveryProvider.replaceRoot(this.directoryList, root);
    }

    private synchronized void ensureDiscoveryResult() {
        if (this.discoveryDocs == null) {
            DiscoveryGenerator.Result result = this.generator.writeDiscovery((Iterable<ApiConfig>)this.getAllApiConfigs(), new DiscoveryGenerator.DiscoveryContext().setApiRoot(PLACEHOLDER_ROOT), this.repository);
            this.directoryList = result.directory();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : result.discoveryDocs().entrySet()) {
                ApiKey rootedKey = (ApiKey)entry.getKey();
                builder.put((Object)new ApiKey(rootedKey.getName(), rootedKey.getVersion(), null), entry.getValue());
            }
            this.discoveryDocs = builder.build();
        }
    }

    private static RestDescription replaceRoot(RestDescription doc, String newRoot) {
        if (doc == null) {
            return null;
        }
        newRoot = Strings.stripTrailingSlash(newRoot);
        return doc.clone().setBaseUrl(doc.getBaseUrl().replaceFirst(PLACEHOLDER_ROOT, newRoot)).setRootUrl(doc.getRootUrl().replaceFirst(PLACEHOLDER_ROOT, newRoot));
    }

    private static DirectoryList replaceRoot(DirectoryList directory, String newRoot) {
        if (directory == null) {
            return null;
        }
        newRoot = Strings.stripTrailingSlash(newRoot);
        directory = directory.clone();
        for (DirectoryList.Items item : directory.getItems()) {
            item.setDiscoveryRestUrl(item.getDiscoveryRestUrl().replaceFirst(PLACEHOLDER_ROOT, newRoot));
        }
        return directory;
    }
}

