/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.model.ApiClassConfig;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiIssuerAudienceConfig;
import com.google.api.server.spi.config.model.ApiMetricCostConfig;
import com.google.api.server.spi.config.model.ApiParameterConfig;
import com.google.api.server.spi.config.model.Types;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiMethodConfig {
    private final String endpointMethodName;
    private final List<ApiParameterConfig> parameterConfigs;
    private final ApiClassConfig apiClassConfig;
    private String name;
    private String description;
    private String path;
    private String canonicalPath;
    private String httpMethod;
    private AuthLevel authLevel;
    private AuthScopeExpression scopeExpression;
    private List<String> audiences;
    private ApiIssuerAudienceConfig issuerAudiences;
    private List<String> clientIds;
    private List<Class<? extends Authenticator>> authenticators;
    private List<Class<? extends PeerAuthenticator>> peerAuthenticators;
    private boolean ignored = false;
    private Boolean apiKeyRequired;
    private TypeToken<?> returnType;
    private List<ApiMetricCostConfig> metricCosts;
    private final TypeLoader typeLoader;

    public ApiMethodConfig(EndpointMethod method, TypeLoader typeLoader, ApiClassConfig apiClassConfig) {
        this.endpointMethodName = method.getMethod().getName();
        this.parameterConfigs = new ArrayList<ApiParameterConfig>();
        this.apiClassConfig = apiClassConfig;
        this.typeLoader = typeLoader;
        this.setDefaults(method, typeLoader, apiClassConfig.getResource());
    }

    public ApiMethodConfig(ApiMethodConfig original, ApiClassConfig apiClassConfig) {
        this.endpointMethodName = original.endpointMethodName;
        this.apiClassConfig = apiClassConfig;
        this.name = original.name;
        this.path = original.path;
        this.canonicalPath = original.canonicalPath;
        this.description = original.description;
        this.httpMethod = original.httpMethod;
        this.scopeExpression = original.scopeExpression;
        this.audiences = original.audiences == null ? null : new ArrayList<String>(original.audiences);
        this.issuerAudiences = original.issuerAudiences;
        this.clientIds = original.clientIds == null ? null : new ArrayList<String>(original.clientIds);
        this.authenticators = original.authenticators == null ? null : new ArrayList<Class<? extends Authenticator>>(original.authenticators);
        this.peerAuthenticators = original.peerAuthenticators == null ? null : new ArrayList<Class<? extends PeerAuthenticator>>(original.peerAuthenticators);
        this.ignored = original.ignored;
        this.apiKeyRequired = original.apiKeyRequired;
        this.returnType = original.returnType;
        this.typeLoader = original.typeLoader;
        this.metricCosts = original.metricCosts;
        this.parameterConfigs = new ArrayList<ApiParameterConfig>(original.parameterConfigs.size());
        for (ApiParameterConfig parameter : original.parameterConfigs) {
            this.parameterConfigs.add(new ApiParameterConfig(parameter, this));
        }
    }

    protected void setDefaults(EndpointMethod endpointMethod, TypeLoader typeLoader, String apiDefaultResource) {
        Method method = endpointMethod.getMethod();
        RestMethod restMethod = this.getRestMethod(method);
        String resourceTypeName = apiDefaultResource != null ? apiDefaultResource.toLowerCase() : restMethod.guessResourceName(this.apiClassConfig.getApiConfig(), endpointMethod, typeLoader.getClassTypes());
        this.name = null;
        this.httpMethod = (String)Preconditions.checkNotNull((Object)restMethod.getHttpMethod(), (Object)"httpMethod");
        this.setPath((String)Preconditions.checkNotNull((Object)(resourceTypeName == null ? method.getName() : resourceTypeName.toLowerCase()), (Object)"path"));
        this.authLevel = AuthLevel.UNSPECIFIED;
        this.scopeExpression = null;
        this.audiences = null;
        this.issuerAudiences = ApiIssuerAudienceConfig.UNSPECIFIED;
        this.clientIds = null;
        this.authenticators = null;
        this.peerAuthenticators = null;
        this.ignored = false;
        this.apiKeyRequired = null;
        this.returnType = endpointMethod.getReturnType();
        this.metricCosts = ImmutableList.of();
    }

    private RestMethod getRestMethod(Method method) {
        String methodName = method.getName();
        for (RestMethod entry : RestMethod.values()) {
            if (!methodName.startsWith(entry.getMethodNamePrefix())) continue;
            return entry;
        }
        throw new AssertionError((Object)("It's impossible for method" + method + " to map to no REST path."));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiMethodConfig) {
            ApiMethodConfig config = (ApiMethodConfig)o;
            return Objects.equals(this.endpointMethodName, config.endpointMethodName) && this.parameterConfigs.equals(config.parameterConfigs) && Objects.equals(this.name, config.name) && Objects.equals(this.path, config.path) && Objects.equals(this.httpMethod, config.httpMethod) && Objects.equals(this.scopeExpression, config.scopeExpression) && Objects.equals(this.audiences, config.audiences) && Objects.equals(this.issuerAudiences, config.issuerAudiences) && Objects.equals(this.clientIds, config.clientIds) && Objects.equals(this.authenticators, config.authenticators) && Objects.equals(this.peerAuthenticators, config.peerAuthenticators) && Objects.equals(this.typeLoader, config.typeLoader) && this.ignored == config.ignored && this.apiKeyRequired == config.apiKeyRequired && Objects.equals(this.returnType, config.returnType) && Objects.equals(this.metricCosts, config.metricCosts);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.endpointMethodName, this.parameterConfigs, this.name, this.path, this.httpMethod, this.scopeExpression, this.audiences, this.clientIds, this.authenticators, this.peerAuthenticators, this.typeLoader, this.ignored, this.issuerAudiences, this.apiKeyRequired, this.returnType, this.metricCosts);
    }

    public ApiClassConfig getApiClassConfig() {
        return this.apiClassConfig;
    }

    public ApiConfig getApiConfig() {
        return this.apiClassConfig.getApiConfig();
    }

    public String getEndpointMethodName() {
        return this.endpointMethodName;
    }

    public String getFullJavaName() {
        return this.apiClassConfig.getApiClassJavaName() + "." + this.getEndpointMethodName();
    }

    public ApiParameterConfig addParameter(String name, String description, boolean nullable, String defaultValue, TypeToken<?> type) {
        String pathFragment;
        ApiParameterConfig config = new ApiParameterConfig(this, name, description, nullable, defaultValue, type, this.typeLoader);
        this.parameterConfigs.add(config);
        if (config.getClassification() != ApiParameterConfig.Classification.INJECTED && name != null && !nullable && defaultValue == null && !this.path.contains(pathFragment = "{" + name + "}")) {
            this.setPath(this.path + "/" + pathFragment);
        }
        return config;
    }

    public List<ApiParameterConfig> getParameterConfigs() {
        return this.parameterConfigs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.apiClassConfig.getResource() != null) {
            return String.format("%s.%s", this.apiClassConfig.getResource(), this.endpointMethodName);
        }
        if (this.apiClassConfig.getApiClassJavaSimpleName().isEmpty()) {
            return String.format("%s", this.endpointMethodName);
        }
        return String.format("%s.%s", this.apiClassConfig.getApiClassJavaSimpleName(), this.endpointMethodName);
    }

    public static String methodNameFormatter(String methodName) {
        StringBuilder builder = new StringBuilder();
        for (String s : methodName.split("\\.")) {
            if (s.isEmpty()) continue;
            builder.append(Character.toLowerCase(s.charAt(0))).append(s.substring(1)).append('.');
        }
        if (builder.length() == 0) {
            return builder.toString();
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    public String getFullMethodName() {
        return ApiMethodConfig.methodNameFormatter(this.apiClassConfig.getApiConfig().getName() + "." + this.getName());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPath(String path) {
        this.path = path;
        this.canonicalPath = path.startsWith("/") ? path.substring(1) : this.getApiConfig().getName() + "/" + this.getApiConfig().getVersion() + "/" + path;
    }

    public String getPath() {
        return this.path;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getRestfulSignature() {
        return this.getHttpMethod() + " " + this.getPath().replaceAll("\\{([^\\}]*)\\}", "\\{\\}");
    }

    public void setAuthLevel(AuthLevel authLevel) {
        this.authLevel = authLevel;
    }

    public AuthLevel getAuthLevel() {
        return this.authLevel != AuthLevel.UNSPECIFIED ? this.authLevel : this.apiClassConfig.getAuthLevel();
    }

    public void setScopeExpression(AuthScopeExpression scopeExpression) {
        this.scopeExpression = scopeExpression;
    }

    public AuthScopeExpression getScopeExpression() {
        return this.scopeExpression != null ? this.scopeExpression : this.apiClassConfig.getScopeExpression();
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public List<String> getAudiences() {
        return this.audiences != null ? this.audiences : this.apiClassConfig.getAudiences();
    }

    public void setIssuerAudiences(ApiIssuerAudienceConfig issuerAudiences) {
        Preconditions.checkNotNull((Object)issuerAudiences, (Object)"issuerAudiences should never be null");
        this.issuerAudiences = issuerAudiences;
        if (issuerAudiences.hasIssuer("google_id_token")) {
            this.getApiClassConfig().getApiConfig().ensureGoogleIssuer();
        }
    }

    public ApiIssuerAudienceConfig getIssuerAudiences() {
        return this.issuerAudiences.isSpecified() ? this.issuerAudiences : this.apiClassConfig.getIssuerAudiences();
    }

    public void setClientIds(List<String> clientIds) {
        this.clientIds = clientIds;
    }

    public List<String> getClientIds() {
        return this.clientIds != null ? this.clientIds : this.apiClassConfig.getClientIds();
    }

    public void setAuthenticators(List<Class<? extends Authenticator>> authenticators) {
        this.authenticators = authenticators;
    }

    public List<Class<? extends Authenticator>> getAuthenticators() {
        return this.authenticators != null ? this.authenticators : this.apiClassConfig.getAuthenticators();
    }

    public void setPeerAuthenticators(List<Class<? extends PeerAuthenticator>> peerAuthenticators) {
        this.peerAuthenticators = peerAuthenticators;
    }

    public List<Class<? extends PeerAuthenticator>> getPeerAuthenticators() {
        return this.peerAuthenticators != null ? this.peerAuthenticators : this.apiClassConfig.getPeerAuthenticators();
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setApiKeyRequired(boolean apiKeyRequired) {
        this.apiKeyRequired = apiKeyRequired;
    }

    public boolean isApiKeyRequired() {
        return this.apiKeyRequired != null ? this.apiKeyRequired.booleanValue() : this.apiClassConfig.isApiKeyRequired();
    }

    public Collection<String> getPathParameters() {
        Pattern pathPattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher pathMatcher = pathPattern.matcher(this.path);
        HashSet<String> pathParameters = new HashSet<String>();
        while (pathMatcher.find()) {
            pathParameters.add(pathMatcher.group(1));
        }
        return pathParameters;
    }

    public TypeToken<?> getReturnType() {
        return this.returnType;
    }

    public boolean hasResourceInResponse() {
        Class returnType = this.getReturnType().getRawType();
        return returnType != Void.TYPE && returnType != Void.class;
    }

    public void setMetricCosts(List<ApiMetricCostConfig> metricCosts) {
        this.metricCosts = metricCosts;
    }

    public List<ApiMetricCostConfig> getMetricCosts() {
        return this.metricCosts;
    }

    private static enum RestMethod {
        LIST("list", "GET"){

            @Override
            public String guessResourceName(ApiConfig config, EndpointMethod method, Map<String, Class<?>> classTypes) {
                TypeToken<?> returnType = method.getReturnType();
                if (this.isValidCollectionType(returnType)) {
                    return Types.getSimpleName(Types.getTypeParameter(returnType, 0), config.getSerializationConfig()).toLowerCase();
                }
                return null;
            }

            private boolean isValidCollectionType(TypeToken<?> type) {
                return type.isSubtypeOf(Collection.class) || Types.isCollectionResponseType(type);
            }
        }
        ,
        GET("get", "GET"),
        INSERT("insert", "POST"),
        UPDATE("update", "PUT"),
        DELETE("delete", "DELETE"){

            @Override
            public String guessResourceName(ApiConfig config, EndpointMethod method, Map<String, Class<?>> classTypes) {
                String methodName = method.getMethod().getName();
                return this.methodNamePrefix.length() >= methodName.length() ? null : methodName.substring(this.methodNamePrefix.length()).toLowerCase();
            }
        }
        ,
        REMOVE("remove", "DELETE"){

            @Override
            public String guessResourceName(ApiConfig config, EndpointMethod method, Map<String, Class<?>> classTypes) {
                String methodName = method.getMethod().getName();
                return this.methodNamePrefix.length() >= methodName.length() ? null : methodName.substring(this.methodNamePrefix.length()).toLowerCase();
            }
        }
        ,
        DEFAULT("", "POST"){

            @Override
            public String guessResourceName(ApiConfig config, EndpointMethod method, Map<String, Class<?>> classTypes) {
                return null;
            }
        };

        protected final String methodNamePrefix;
        private final String httpMethod;

        private RestMethod(String methodNamePrefix, String httpMethod) {
            this.methodNamePrefix = methodNamePrefix;
            this.httpMethod = httpMethod;
        }

        public String getMethodNamePrefix() {
            return this.methodNamePrefix;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String guessResourceName(ApiConfig config, EndpointMethod method, Map<String, Class<?>> classTypes) {
            return Types.getSimpleName(method.getReturnType(), config.getSerializationConfig()).toLowerCase();
        }
    }
}

