/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EndpointMethod;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class MethodHierarchyReader {
    private final Class<?> endpointClass;
    private ListMultimap<EndpointMethod.ResolvedSignature, EndpointMethod> endpointMethods;

    public MethodHierarchyReader(Class<?> endpointClass) {
        Preconditions.checkArgument((!Modifier.isAbstract(endpointClass.getModifiers()) && !Modifier.isInterface(endpointClass.getModifiers()) ? 1 : 0) != 0, (String)"A concrete class is expected, but got %s.", (Object)endpointClass.getName());
        this.endpointClass = endpointClass;
    }

    private void readMethodHierarchyIfNecessary() {
        if (this.endpointMethods == null) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            this.buildServiceMethods((ImmutableListMultimap.Builder<EndpointMethod.ResolvedSignature, EndpointMethod>)builder, TypeToken.of(this.endpointClass));
            this.endpointMethods = builder.build();
        }
    }

    private EndpointMethod getLeafMethod(List<EndpointMethod> overrides) {
        return overrides.get(0);
    }

    private static <K, V> Map<K, List<V>> asMap(ListMultimap<K, V> multimap) {
        return multimap.asMap();
    }

    public Iterable<Method> getLeafMethods() {
        this.readMethodHierarchyIfNecessary();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<EndpointMethod> overrides : MethodHierarchyReader.asMap(this.endpointMethods).values()) {
            builder.add((Object)this.getLeafMethod(overrides).getMethod());
        }
        return builder.build();
    }

    public Iterable<EndpointMethod> getLeafEndpointMethods() {
        this.readMethodHierarchyIfNecessary();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<EndpointMethod> overrides : MethodHierarchyReader.asMap(this.endpointMethods).values()) {
            builder.add((Object)this.getLeafMethod(overrides));
        }
        return builder.build();
    }

    public Iterable<List<Method>> getMethodOverrides() {
        this.readMethodHierarchyIfNecessary();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<EndpointMethod> overrides : MethodHierarchyReader.asMap(this.endpointMethods).values()) {
            ImmutableList.Builder methodBuilder = ImmutableList.builder();
            for (EndpointMethod method : overrides) {
                methodBuilder.add((Object)method.getMethod());
            }
            builder.add((Object)methodBuilder.build());
        }
        return builder.build();
    }

    public Iterable<List<EndpointMethod>> getEndpointOverrides() {
        this.readMethodHierarchyIfNecessary();
        return MethodHierarchyReader.asMap(this.endpointMethods).values();
    }

    public Map<String, Method> getNameToLeafMethodMap() {
        this.readMethodHierarchyIfNecessary();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (List<EndpointMethod> overrides : MethodHierarchyReader.asMap(this.endpointMethods).values()) {
            Method leafMethod = this.getLeafMethod(overrides).getMethod();
            builder.put((Object)leafMethod.getName(), (Object)leafMethod);
        }
        return builder.build();
    }

    public ListMultimap<String, EndpointMethod> getNameToEndpointOverridesMap() {
        this.readMethodHierarchyIfNecessary();
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (List<EndpointMethod> overrides : MethodHierarchyReader.asMap(this.endpointMethods).values()) {
            builder.putAll((Object)this.getLeafMethod(overrides).getMethod().getName(), overrides);
        }
        return builder.build();
    }

    private void buildServiceMethods(ImmutableListMultimap.Builder<EndpointMethod.ResolvedSignature, EndpointMethod> builder, TypeToken<?> serviceType) {
        for (TypeToken typeToken : serviceType.getTypes().classes()) {
            Class serviceClass = typeToken.getRawType();
            if (Object.class.equals((Object)serviceClass)) {
                return;
            }
            for (Method method : serviceClass.getDeclaredMethods()) {
                if (!MethodHierarchyReader.isServiceMethod(method)) continue;
                EndpointMethod currentMethod = EndpointMethod.create(this.endpointClass, method, typeToken);
                builder.put((Object)currentMethod.getResolvedMethodSignature(), (Object)currentMethod);
            }
        }
    }

    @VisibleForTesting
    static boolean isServiceMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !method.isBridge();
    }
}

