/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.discovery;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.discovery.DiscoveryRequest;
import com.google.api.services.discovery.DiscoveryRequestInitializer;
import com.google.api.services.discovery.model.ApiConfig;
import com.google.api.services.discovery.model.ApiConfigs;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import java.io.IOException;

public class Discovery
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://webapis-discovery.appspot.com/_ah/api/";
    public static final String DEFAULT_SERVICE_PATH = "discovery/v1/";
    public static final String DEFAULT_BASE_URL = "https://webapis-discovery.appspot.com/_ah/api/discovery/v1/";

    public Discovery(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Discovery(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Apis apis() {
        return new Apis();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the APIs Discovery Service library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Discovery.DEFAULT_ROOT_URL, Discovery.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Discovery build() {
            return new Discovery(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDiscoveryRequestInitializer(DiscoveryRequestInitializer discoveryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)discoveryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Apis {
        public GenerateDirectory generateDirectory(ApiConfigs content) throws IOException {
            GenerateDirectory result = new GenerateDirectory(content);
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateRest generateRest(ApiConfig content) throws IOException {
            GenerateRest result = new GenerateRest(content);
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateRpc generateRpc(ApiConfig content) throws IOException {
            GenerateRpc result = new GenerateRpc(content);
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetRest getRest(String api, String version) throws IOException {
            GetRest result = new GetRest(api, version);
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetRpc getRpc(String api, String version) throws IOException {
            GetRpc result = new GetRpc(api, version);
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Discovery.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DiscoveryRequest<DirectoryList> {
            private static final String REST_PATH = "apis";
            @Key
            private String name;
            @Key
            private Boolean preferred;

            protected List() {
                super(Discovery.this, "GET", REST_PATH, null, DirectoryList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public Boolean getPreferred() {
                return this.preferred;
            }

            public List setPreferred(Boolean preferred) {
                this.preferred = preferred;
                return this;
            }

            public boolean isPreferred() {
                if (this.preferred == null || this.preferred == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.preferred;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetRpc
        extends DiscoveryRequest<RpcDescription> {
            private static final String REST_PATH = "apis/{api}/{version}/rpc";
            @Key
            private String api;
            @Key
            private String version;

            protected GetRpc(String api, String version) {
                super(Discovery.this, "GET", REST_PATH, null, RpcDescription.class);
                this.api = (String)Preconditions.checkNotNull((Object)api, (Object)"Required parameter api must be specified.");
                this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"Required parameter version must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRpc setAlt(String alt) {
                return (GetRpc)super.setAlt(alt);
            }

            public GetRpc setFields(String fields) {
                return (GetRpc)super.setFields(fields);
            }

            public GetRpc setKey(String key) {
                return (GetRpc)super.setKey(key);
            }

            public GetRpc setOauthToken(String oauthToken) {
                return (GetRpc)super.setOauthToken(oauthToken);
            }

            public GetRpc setPrettyPrint(Boolean prettyPrint) {
                return (GetRpc)super.setPrettyPrint(prettyPrint);
            }

            public GetRpc setQuotaUser(String quotaUser) {
                return (GetRpc)super.setQuotaUser(quotaUser);
            }

            public GetRpc setUserIp(String userIp) {
                return (GetRpc)super.setUserIp(userIp);
            }

            public String getApi() {
                return this.api;
            }

            public GetRpc setApi(String api) {
                this.api = api;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public GetRpc setVersion(String version) {
                this.version = version;
                return this;
            }

            @Override
            public GetRpc set(String parameterName, Object value) {
                return (GetRpc)super.set(parameterName, value);
            }
        }

        public class GetRest
        extends DiscoveryRequest<RestDescription> {
            private static final String REST_PATH = "apis/{api}/{version}/rest";
            @Key
            private String api;
            @Key
            private String version;

            protected GetRest(String api, String version) {
                super(Discovery.this, "GET", REST_PATH, null, RestDescription.class);
                this.api = (String)Preconditions.checkNotNull((Object)api, (Object)"Required parameter api must be specified.");
                this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"Required parameter version must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRest setAlt(String alt) {
                return (GetRest)super.setAlt(alt);
            }

            public GetRest setFields(String fields) {
                return (GetRest)super.setFields(fields);
            }

            public GetRest setKey(String key) {
                return (GetRest)super.setKey(key);
            }

            public GetRest setOauthToken(String oauthToken) {
                return (GetRest)super.setOauthToken(oauthToken);
            }

            public GetRest setPrettyPrint(Boolean prettyPrint) {
                return (GetRest)super.setPrettyPrint(prettyPrint);
            }

            public GetRest setQuotaUser(String quotaUser) {
                return (GetRest)super.setQuotaUser(quotaUser);
            }

            public GetRest setUserIp(String userIp) {
                return (GetRest)super.setUserIp(userIp);
            }

            public String getApi() {
                return this.api;
            }

            public GetRest setApi(String api) {
                this.api = api;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public GetRest setVersion(String version) {
                this.version = version;
                return this;
            }

            @Override
            public GetRest set(String parameterName, Object value) {
                return (GetRest)super.set(parameterName, value);
            }
        }

        public class GenerateRpc
        extends DiscoveryRequest<RpcDescription> {
            private static final String REST_PATH = "apis/generate/rpc";

            protected GenerateRpc(ApiConfig content) {
                super(Discovery.this, "POST", REST_PATH, (Object)content, RpcDescription.class);
            }

            public GenerateRpc setAlt(String alt) {
                return (GenerateRpc)super.setAlt(alt);
            }

            public GenerateRpc setFields(String fields) {
                return (GenerateRpc)super.setFields(fields);
            }

            public GenerateRpc setKey(String key) {
                return (GenerateRpc)super.setKey(key);
            }

            public GenerateRpc setOauthToken(String oauthToken) {
                return (GenerateRpc)super.setOauthToken(oauthToken);
            }

            public GenerateRpc setPrettyPrint(Boolean prettyPrint) {
                return (GenerateRpc)super.setPrettyPrint(prettyPrint);
            }

            public GenerateRpc setQuotaUser(String quotaUser) {
                return (GenerateRpc)super.setQuotaUser(quotaUser);
            }

            public GenerateRpc setUserIp(String userIp) {
                return (GenerateRpc)super.setUserIp(userIp);
            }

            @Override
            public GenerateRpc set(String parameterName, Object value) {
                return (GenerateRpc)super.set(parameterName, value);
            }
        }

        public class GenerateRest
        extends DiscoveryRequest<RestDescription> {
            private static final String REST_PATH = "apis/generate/rest";

            protected GenerateRest(ApiConfig content) {
                super(Discovery.this, "POST", REST_PATH, (Object)content, RestDescription.class);
            }

            public GenerateRest setAlt(String alt) {
                return (GenerateRest)super.setAlt(alt);
            }

            public GenerateRest setFields(String fields) {
                return (GenerateRest)super.setFields(fields);
            }

            public GenerateRest setKey(String key) {
                return (GenerateRest)super.setKey(key);
            }

            public GenerateRest setOauthToken(String oauthToken) {
                return (GenerateRest)super.setOauthToken(oauthToken);
            }

            public GenerateRest setPrettyPrint(Boolean prettyPrint) {
                return (GenerateRest)super.setPrettyPrint(prettyPrint);
            }

            public GenerateRest setQuotaUser(String quotaUser) {
                return (GenerateRest)super.setQuotaUser(quotaUser);
            }

            public GenerateRest setUserIp(String userIp) {
                return (GenerateRest)super.setUserIp(userIp);
            }

            @Override
            public GenerateRest set(String parameterName, Object value) {
                return (GenerateRest)super.set(parameterName, value);
            }
        }

        public class GenerateDirectory
        extends DiscoveryRequest<DirectoryList> {
            private static final String REST_PATH = "apis/generate/directory";

            protected GenerateDirectory(ApiConfigs content) {
                super(Discovery.this, "POST", REST_PATH, (Object)content, DirectoryList.class);
            }

            public GenerateDirectory setAlt(String alt) {
                return (GenerateDirectory)super.setAlt(alt);
            }

            public GenerateDirectory setFields(String fields) {
                return (GenerateDirectory)super.setFields(fields);
            }

            public GenerateDirectory setKey(String key) {
                return (GenerateDirectory)super.setKey(key);
            }

            public GenerateDirectory setOauthToken(String oauthToken) {
                return (GenerateDirectory)super.setOauthToken(oauthToken);
            }

            public GenerateDirectory setPrettyPrint(Boolean prettyPrint) {
                return (GenerateDirectory)super.setPrettyPrint(prettyPrint);
            }

            public GenerateDirectory setQuotaUser(String quotaUser) {
                return (GenerateDirectory)super.setQuotaUser(quotaUser);
            }

            public GenerateDirectory setUserIp(String userIp) {
                return (GenerateDirectory)super.setUserIp(userIp);
            }

            @Override
            public GenerateDirectory set(String parameterName, Object value) {
                return (GenerateDirectory)super.set(parameterName, value);
            }
        }
    }
}

