/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.model.Schema;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import javax.annotation.Nullable;

final class AutoValue_Schema
extends Schema {
    private final String name;
    private final String type;
    private final String description;
    private final ImmutableSortedMap<String, Schema.Field> fields;
    private final ImmutableList<String> enumValues;
    private final ImmutableList<String> enumDescriptions;

    private AutoValue_Schema(String name, String type, @Nullable String description, ImmutableSortedMap<String, Schema.Field> fields, @Nullable ImmutableList<String> enumValues, @Nullable ImmutableList<String> enumDescriptions) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.description = description;
        if (fields == null) {
            throw new NullPointerException("Null fields");
        }
        this.fields = fields;
        this.enumValues = enumValues;
        this.enumDescriptions = enumDescriptions;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    public ImmutableSortedMap<String, Schema.Field> fields() {
        return this.fields;
    }

    @Override
    @Nullable
    public ImmutableList<String> enumValues() {
        return this.enumValues;
    }

    @Override
    @Nullable
    public ImmutableList<String> enumDescriptions() {
        return this.enumDescriptions;
    }

    public String toString() {
        return "Schema{name=" + this.name + ", type=" + this.type + ", description=" + this.description + ", fields=" + this.fields + ", enumValues=" + this.enumValues + ", enumDescriptions=" + this.enumDescriptions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Schema) {
            Schema that = (Schema)o;
            return this.name.equals(that.name()) && this.type.equals(that.type()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.fields.equals(that.fields()) && (this.enumValues == null ? that.enumValues() == null : this.enumValues.equals(that.enumValues())) && (this.enumDescriptions == null ? that.enumDescriptions() == null : this.enumDescriptions.equals(that.enumDescriptions()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.fields.hashCode();
        h *= 1000003;
        h ^= this.enumValues == null ? 0 : this.enumValues.hashCode();
        h *= 1000003;
        return h ^= this.enumDescriptions == null ? 0 : this.enumDescriptions.hashCode();
    }

    static final class Builder
    extends Schema.Builder {
        private String name;
        private String type;
        private String description;
        private ImmutableSortedMap<String, Schema.Field> fields;
        private ImmutableList.Builder<String> enumValuesBuilder$;
        private ImmutableList<String> enumValues;
        private ImmutableList.Builder<String> enumDescriptionsBuilder$;
        private ImmutableList<String> enumDescriptions;

        Builder() {
            this.enumValues = ImmutableList.of();
            this.enumDescriptions = ImmutableList.of();
        }

        Builder(Schema source) {
            this.name = source.name();
            this.type = source.type();
            this.description = source.description();
            this.fields = source.fields();
            this.enumValues = source.enumValues();
            this.enumDescriptions = source.enumDescriptions();
        }

        @Override
        public Schema.Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Schema.Builder setType(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Schema.Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public Schema.Builder setFields(ImmutableSortedMap<String, Schema.Field> fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public ImmutableList.Builder<String> enumValuesBuilder() {
            if (this.enumValuesBuilder$ == null) {
                this.enumValuesBuilder$ = ImmutableList.builder();
                this.enumValuesBuilder$.addAll(this.enumValues);
                this.enumValues = null;
            }
            return this.enumValuesBuilder$;
        }

        @Override
        public ImmutableList.Builder<String> enumDescriptionsBuilder() {
            if (this.enumDescriptionsBuilder$ == null) {
                this.enumDescriptionsBuilder$ = ImmutableList.builder();
                this.enumDescriptionsBuilder$.addAll(this.enumDescriptions);
                this.enumDescriptions = null;
            }
            return this.enumDescriptionsBuilder$;
        }

        @Override
        public Schema autoBuild() {
            if (this.enumValuesBuilder$ != null) {
                this.enumValues = this.enumValuesBuilder$.build();
            }
            if (this.enumDescriptionsBuilder$ != null) {
                this.enumDescriptions = this.enumDescriptionsBuilder$.build();
            }
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.fields == null) {
                missing = missing + " fields";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Schema(this.name, this.type, this.description, this.fields, this.enumValues, this.enumDescriptions);
        }
    }
}

