/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.auth.EndpointsPeerAuthenticator;
import com.google.api.server.spi.config.PeerAuthenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.request.Attribute;
import com.google.common.annotations.VisibleForTesting;
import javax.servlet.http.HttpServletRequest;

public class PeerAuth {
    private static final Singleton.Instantiator<PeerAuthenticator> INSTANTIATOR = new Singleton.Instantiator<EndpointsPeerAuthenticator>(new EndpointsPeerAuthenticator());
    private final HttpServletRequest request;
    private final Attribute attr;
    private final ApiMethodConfig config;

    public static PeerAuthenticator instantiatePeerAuthenticator(Class<? extends PeerAuthenticator> clazz) {
        return INSTANTIATOR.getInstanceOrDefault(clazz);
    }

    @VisibleForTesting
    PeerAuth(HttpServletRequest request) {
        this.request = request;
        this.attr = Attribute.from(request);
        this.config = (ApiMethodConfig)this.attr.get("endpoints:Api-Method-Config");
    }

    static PeerAuth from(HttpServletRequest request) {
        return new PeerAuth(request);
    }

    @VisibleForTesting
    Iterable<PeerAuthenticator> getPeerAuthenticatorInstances() {
        return INSTANTIATOR.getInstancesOrDefault(this.config.getPeerAuthenticators());
    }

    boolean authorizePeer() {
        if (!this.attr.isEnabled("endpoints:Restrict-Servlet")) {
            return true;
        }
        Iterable<PeerAuthenticator> peerAuthenticators = this.getPeerAuthenticatorInstances();
        if (peerAuthenticators != null) {
            for (PeerAuthenticator peerAuthenticator : peerAuthenticators) {
                if (peerAuthenticator.authenticate(this.request)) continue;
                return false;
            }
        }
        return true;
    }
}

